/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axrewards.guis.data;

import com.artillexstudios.axrewards.AxRewards;
import com.artillexstudios.axrewards.guis.data.Menu;
import com.artillexstudios.axrewards.guis.data.Reward;
import com.artillexstudios.axrewards.guis.impl.RewardGui;
import com.artillexstudios.axrewards.libs.axapi.config.Config;
import com.artillexstudios.axrewards.libs.axapi.libs.boostedyaml.block.implementation.Section;
import com.artillexstudios.axrewards.libs.axapi.utils.ItemBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;

public class MenuManager {
    private static final ConcurrentHashMap<String, Menu> menus = new ConcurrentHashMap();

    public static void reload() {
        for (RewardGui gui : RewardGui.getOpenMenus()) {
            gui.getGui().close((HumanEntity)gui.getPlayer());
        }
        menus.clear();
        File path = new File(AxRewards.getInstance().getDataFolder(), "menus");
        if (!path.exists()) {
            return;
        }
        for (File file : path.listFiles()) {
            if (!file.getName().endsWith(".yml") && !file.getName().endsWith(".yaml")) continue;
            String name = file.getName().replace(".yml", "").replace(".yaml", "");
            Config config = new Config(file);
            ArrayList<Reward> rewards = new ArrayList<Reward>();
            Menu menu = new Menu(name, config, rewards);
            for (String route : config.getBackingDocument().getRoutesAsStrings(false)) {
                Section claimableSection;
                Section s = config.getSection(route);
                if (s == null || (claimableSection = s.getSection("claimable", null)) == null) continue;
                Section permissionItem = s.getSection("no-permission");
                long cd = s.getLong("cooldown");
                Reward reward = new Reward(menu, route, s.getInt("slot"), cd == -1L ? -1L : s.getLong("cooldown") * 1000L, s.getStringList("claim-commands"), s.getMapList("claim-items"), ItemBuilder.create(claimableSection).get(), ItemBuilder.create(s.getSection("unclaimable")).get(), s.getString("permission", null), permissionItem == null ? null : ItemBuilder.create(permissionItem).get());
                rewards.add(reward);
            }
            menus.put(name, menu);
        }
    }

    public static ConcurrentHashMap<String, Menu> getMenus() {
        return menus;
    }

    public static void openMenu(Player player, Menu menu, boolean force) {
        if (!(force || player.hasPermission("axrewards.open.*") || player.hasPermission("axrewards.open." + menu.name()))) {
            AxRewards.MESSAGEUTILS.sendLang((CommandSender)player, "errors.no-open-permission", Map.of("%menu%", menu.name()));
            return;
        }
        new RewardGui(player, menu).open();
    }

    public static Menu getFallBack() {
        if (MenuManager.getMenus().isEmpty()) {
            return null;
        }
        Menu menu = menus.get("default");
        if (menu == null) {
            Optional<Menu> optionalMenu = MenuManager.getMenus().values().stream().findFirst();
            if (optionalMenu.isEmpty()) {
                return null;
            }
            menu = optionalMenu.get();
        }
        return menu;
    }

    public static int getClaimable(Player player, Menu menu) {
        int am = 0;
        for (Reward reward : menu.rewards()) {
            boolean hasPermission;
            long lastClaim = AxRewards.getDatabase().getLastClaim((OfflinePlayer)player, reward);
            boolean canClaim = MenuManager.canClaimReward(reward, lastClaim);
            String permission = reward.claimPermission();
            boolean bl = hasPermission = permission == null || player.hasPermission(permission);
            if (!canClaim || !hasPermission) continue;
            ++am;
        }
        return am;
    }

    public static boolean canClaimReward(Reward reward, long lastClaim) {
        boolean onCooldown = lastClaim + reward.cooldown() > System.currentTimeMillis();
        boolean claimFailed = lastClaim == -1L;
        boolean oneTimeClaimed = lastClaim > 0L && reward.cooldown() == -1L;
        return !onCooldown && !claimFailed && !oneTimeClaimed;
    }
}

