/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axrewards.guis;

import com.artillexstudios.axrewards.libs.axapi.config.Config;
import com.artillexstudios.axrewards.libs.gui.components.GuiAction;
import com.artillexstudios.axrewards.libs.gui.guis.BaseGui;
import com.artillexstudios.axrewards.libs.gui.guis.GuiItem;
import com.artillexstudios.axrewards.utils.ItemBuilderUtil;
import com.artillexstudios.axrewards.utils.SoundUtils;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiFrame {
    protected final Config file;
    protected BaseGui gui;
    protected Player player;

    public GuiFrame(Config file, Player player) {
        this.file = file;
        this.player = player;
    }

    public void setGui(BaseGui gui) {
        this.gui = gui;
        for (String str : this.file.getBackingDocument().getRoutesAsStrings(false)) {
            this.createItem(str, str);
        }
    }

    @NotNull
    public Config getFile() {
        return this.file;
    }

    protected ItemStack buildItem(@NotNull String key) {
        return ItemBuilderUtil.newBuilder(this.player, this.file.getSection(key)).get();
    }

    protected ItemStack buildItem(@NotNull String key, Map<String, String> replacements) {
        return ItemBuilderUtil.newBuilder(this.player, this.file.getSection(key), replacements).get();
    }

    protected void createItem(@NotNull String route, String prevRoute) {
        this.createItem(route, prevRoute, event -> SoundUtils.playSound(this.player, this.file.getSection(route + ".sound")), Map.of());
    }

    protected void createItem(@NotNull String route, String prevRoute, @Nullable GuiAction<InventoryClickEvent> action) {
        this.createItem(route, prevRoute, action, Map.of());
    }

    protected void createItem(@NotNull String route, String prevRoute, @Nullable GuiAction<InventoryClickEvent> action, Map<String, String> replacements) {
        if (this.file.getString(route + ".type") == null && this.file.getString(route + ".material") == null) {
            return;
        }
        GuiItem guiItem = new GuiItem(this.buildItem(route, replacements), action);
        List<Integer> slots = this.file.getBackingDocument().getIntList(prevRoute + ".slot");
        if (slots.isEmpty()) {
            this.gui.setItem(this.file.getInt(prevRoute + ".slot"), guiItem);
        } else {
            this.gui.setItem(slots, guiItem);
        }
    }
}

