/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axrewards.database.impl;

import com.artillexstudios.axrewards.database.Converter3;
import com.artillexstudios.axrewards.database.Database;
import com.artillexstudios.axrewards.guis.data.Menu;
import com.artillexstudios.axrewards.guis.data.MenuManager;
import com.artillexstudios.axrewards.guis.data.Reward;
import com.artillexstudios.axrewards.utils.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.bukkit.OfflinePlayer;

public abstract class Base
implements Database {
    private QueryRunner runner;
    private final String CREATE_TABLE1 = "        CREATE TABLE IF NOT EXISTS axrewards_menus (\n            id INT NOT NULL AUTO_INCREMENT,\n            name VARCHAR(128) NOT NULL,\n            PRIMARY KEY (id), UNIQUE (name)\n        );\n";
    private final String CREATE_TABLE2 = "        CREATE TABLE IF NOT EXISTS axrewards_players (\n            id INT NOT NULL AUTO_INCREMENT,\n            uuid VARCHAR(36) NOT NULL,\n            name VARCHAR(128),\n            PRIMARY KEY (id), UNIQUE (uuid)\n        );\n";
    private final String CREATE_TABLE3 = "        CREATE TABLE IF NOT EXISTS axrewards_rewards (\n            id INT NOT NULL AUTO_INCREMENT,\n            name VARCHAR(128) NOT NULL,\n            menu_id INT NOT NULL,\n            PRIMARY KEY (id), UNIQUE (name, menu_id)\n        );\n";
    private final String CREATE_TABLE4 = "        CREATE TABLE IF NOT EXISTS axrewards_cooldowns (\n            id INT NOT NULL AUTO_INCREMENT,\n            player_id INT NOT NULL,\n            reward_id INT NOT NULL,\n            time BIGINT NOT NULL,\n            PRIMARY KEY (id)\n        );\n";
    private final String INSERT_MENU = "        INSERT INTO axrewards_menus (name) VALUES (?)\n";
    private final String SELECT_MENU = "        SELECT id FROM axrewards_menus WHERE name = ? LIMIT 1\n";
    private final String SELECT_PLAYER_BY_UUID = "        SELECT id FROM axrewards_players WHERE uuid = ?\n";
    private final String INSERT_PLAYER = "        INSERT INTO axrewards_players (uuid, name) VALUES (?, ?)\n";
    private final String INSERT_REWARD = "        INSERT INTO axrewards_rewards (name, menu_id) VALUES (?, ?)\n";
    private final String SELECT_REWARD = "        SELECT id FROM axrewards_rewards WHERE name = ? AND menu_id = ?\n";
    private final String LAST_CLAIM = "        SELECT time FROM axrewards_cooldowns WHERE player_id = ? AND reward_id = ? LIMIT 1;\n";
    private final String CLAIM_REWARD = "        INSERT INTO axrewards_cooldowns (player_id, reward_id, time) VALUES (?, ?, ?)\n";
    private final String RESET_REWARD_SPECIFIC = "        DELETE FROM axrewards_cooldowns WHERE player_id = ? AND reward_id = ?\n";
    private final String RESET_REWARD_MENU = "        DELETE FROM axrewards_cooldowns WHERE player_id = ? AND reward_id IN\n        (SELECT id FROM axrewards_rewards WHERE menu_id = ?)\n";
    private final String RESET_REWARD_ALL = "        DELETE FROM axrewards_cooldowns WHERE player_id = ?\n";

    public abstract Connection getConnection();

    @Override
    public abstract String getType();

    public QueryRunner getRunner() {
        return this.runner;
    }

    @Override
    public void setup() {
        Connection conn;
        this.runner = new QueryRunner();
        try {
            conn = this.getConnection();
            try {
                this.runner.execute(conn, "        CREATE TABLE IF NOT EXISTS axrewards_menus (\n            id INT NOT NULL AUTO_INCREMENT,\n            name VARCHAR(128) NOT NULL,\n            PRIMARY KEY (id), UNIQUE (name)\n        );\n", new Object[0]);
                this.runner.execute(conn, "        CREATE TABLE IF NOT EXISTS axrewards_players (\n            id INT NOT NULL AUTO_INCREMENT,\n            uuid VARCHAR(36) NOT NULL,\n            name VARCHAR(128),\n            PRIMARY KEY (id), UNIQUE (uuid)\n        );\n", new Object[0]);
                this.runner.execute(conn, "        CREATE TABLE IF NOT EXISTS axrewards_rewards (\n            id INT NOT NULL AUTO_INCREMENT,\n            name VARCHAR(128) NOT NULL,\n            menu_id INT NOT NULL,\n            PRIMARY KEY (id), UNIQUE (name, menu_id)\n        );\n", new Object[0]);
                this.runner.execute(conn, "        CREATE TABLE IF NOT EXISTS axrewards_cooldowns (\n            id INT NOT NULL AUTO_INCREMENT,\n            player_id INT NOT NULL,\n            reward_id INT NOT NULL,\n            time BIGINT NOT NULL,\n            PRIMARY KEY (id)\n        );\n", new Object[0]);
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        this.reload();
        try {
            conn = this.getConnection();
            try {
                if (SQLUtils.tableExists(conn, "axrewards_claimed")) {
                    new Converter3(this);
                }
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void reload() {
        try (Connection conn = this.getConnection();){
            for (Map.Entry<String, Menu> entry : MenuManager.getMenus().entrySet()) {
                try {
                    this.runner.execute(conn, "        INSERT INTO axrewards_menus (name) VALUES (?)\n", new Object[]{entry.getKey()});
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (Reward reward : entry.getValue().rewards()) {
                    try {
                        this.runner.execute(conn, "        INSERT INTO axrewards_rewards (name, menu_id) VALUES (?, ?)\n", new Object[]{reward.name(), this.getMenuId(reward.menu())});
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getPlayerId(OfflinePlayer player) {
        ScalarHandler scalarHandler = new ScalarHandler();
        try (Connection conn = this.getConnection();){
            Number id = (Number)this.runner.query(conn, "        SELECT id FROM axrewards_players WHERE uuid = ?\n", (ResultSetHandler)scalarHandler, new Object[]{player.getUniqueId().toString()});
            if (id != null) {
                int n2 = id.intValue();
                return n2;
            }
            int n = ((Number)this.runner.insert(conn, "        INSERT INTO axrewards_players (uuid, name) VALUES (?, ?)\n", (ResultSetHandler)scalarHandler, new Object[]{player.getUniqueId().toString(), player.getName()})).intValue();
            return n;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new RuntimeException("Could not create user in database!");
        }
    }

    @Override
    public int getMenuId(Menu menu) {
        int n;
        block8: {
            ScalarHandler scalarHandler = new ScalarHandler();
            Connection conn = this.getConnection();
            try {
                n = (Integer)this.runner.query(conn, "        SELECT id FROM axrewards_menus WHERE name = ? LIMIT 1\n", (ResultSetHandler)scalarHandler, new Object[]{menu.name()});
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                    throw new RuntimeException("Could not find menu " + menu.name() + " in database!");
                }
            }
            conn.close();
        }
        return n;
    }

    @Override
    public int getRewardId(Reward reward) {
        int n;
        block8: {
            ScalarHandler scalarHandler = new ScalarHandler();
            Connection conn = this.getConnection();
            try {
                n = (Integer)this.runner.query(conn, "        SELECT id FROM axrewards_rewards WHERE name = ? AND menu_id = ?\n", (ResultSetHandler)scalarHandler, new Object[]{reward.name(), this.getMenuId(reward.menu())});
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                    throw new RuntimeException("Could not find reward " + reward.name() + " in database!");
                }
            }
            conn.close();
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getLastClaim(OfflinePlayer player, Reward reward) {
        ScalarHandler scalarHandler = new ScalarHandler();
        try (Connection conn = this.getConnection();){
            Long n = (Long)this.runner.query(conn, "        SELECT time FROM axrewards_cooldowns WHERE player_id = ? AND reward_id = ? LIMIT 1;\n", (ResultSetHandler)scalarHandler, new Object[]{this.getPlayerId(player), this.getRewardId(reward)});
            if (n == null) return 0L;
            long l = n;
            return l;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return -1L;
        }
    }

    @Override
    public void claimReward(OfflinePlayer player, Reward reward) {
        this.claimReward(player, reward, System.currentTimeMillis());
    }

    public void claimReward(OfflinePlayer player, Reward reward, long time) {
        this.resetReward(player, reward);
        try (Connection conn = this.getConnection();){
            this.runner.execute(conn, "        INSERT INTO axrewards_cooldowns (player_id, reward_id, time) VALUES (?, ?, ?)\n", new Object[]{this.getPlayerId(player), this.getRewardId(reward), time});
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void resetReward(OfflinePlayer player, Reward reward) {
        try (Connection conn = this.getConnection();){
            this.runner.execute(conn, "        DELETE FROM axrewards_cooldowns WHERE player_id = ? AND reward_id = ?\n", new Object[]{this.getPlayerId(player), this.getRewardId(reward)});
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void resetReward(OfflinePlayer player, Menu menu) {
        try (Connection conn = this.getConnection();){
            this.runner.execute(conn, "        DELETE FROM axrewards_cooldowns WHERE player_id = ? AND reward_id IN\n        (SELECT id FROM axrewards_rewards WHERE menu_id = ?)\n", new Object[]{this.getPlayerId(player), this.getMenuId(menu)});
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void resetReward(OfflinePlayer player) {
        try (Connection conn = this.getConnection();){
            this.runner.execute(conn, "        DELETE FROM axrewards_cooldowns WHERE player_id = ?\n", new Object[]{this.getPlayerId(player)});
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public abstract void disable();
}

