/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.process;

import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import revxrsal.commands.command.CommandParameter;
import revxrsal.commands.process.BuiltInNamingStrategies;

@FunctionalInterface
public interface ParameterNamingStrategy {
    @NotNull
    public String getName(@NotNull CommandParameter var1);

    public static ParameterNamingStrategy identity() {
        return parameter -> parameter.getJavaParameter().getName();
    }

    public static ParameterNamingStrategy lowerCaseWithSeparator(String separator) {
        return parameter -> BuiltInNamingStrategies.separateCamelCase(parameter.getName(), separator).toLowerCase(Locale.ENGLISH);
    }

    public static ParameterNamingStrategy lowerCaseWithSpace() {
        return ParameterNamingStrategy.lowerCaseWithSeparator(" ");
    }

    public static ParameterNamingStrategy upperCamelCase() {
        return parameter -> BuiltInNamingStrategies.upperCaseFirstLetter(parameter.getName());
    }

    public static ParameterNamingStrategy upperCamelCaseWithSpace() {
        return ParameterNamingStrategy.upperCamelCaseWithSeparator(" ");
    }

    public static ParameterNamingStrategy upperCamelCaseWithSeparator(String separator) {
        return parameter -> BuiltInNamingStrategies.upperCaseFirstLetter(BuiltInNamingStrategies.separateCamelCase(parameter.getName(), separator));
    }
}

