/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.command;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import revxrsal.commands.CommandHandler;
import revxrsal.commands.command.ArgumentStack;
import revxrsal.commands.locales.Translator;

public interface CommandActor {
    @NotNull
    public String getName();

    @NotNull
    public UUID getUniqueId();

    public void reply(@NotNull String var1);

    public void error(@NotNull String var1);

    public CommandHandler getCommandHandler();

    default public Translator getTranslator() {
        return this.getCommandHandler().getTranslator();
    }

    @NotNull
    default public Locale getLocale() {
        return this.getTranslator().getLocale();
    }

    default public void replyLocalized(@NotNull String key, Object ... args) {
        String message = MessageFormat.format(this.getTranslator().get(key, this.getLocale()), args);
        this.reply(message);
    }

    default public void errorLocalized(@NotNull String key, Object ... args) {
        String message = MessageFormat.format(this.getTranslator().get(key, this.getLocale()), args);
        this.error(message);
    }

    default public <T> Optional<@Nullable T> dispatch(@NotNull String input) {
        return this.getCommandHandler().dispatch(this, input);
    }

    default public <T> Optional<@Nullable T> dispatch(@NotNull ArgumentStack input) {
        return this.getCommandHandler().dispatch(this, input);
    }

    default public <T extends CommandActor> T as(@NotNull Class<T> type) {
        return (T)((CommandActor)type.cast(this));
    }
}

