/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axrankmenu.hooks.currency;

import com.artillexstudios.axrankmenu.AxRankMenu;
import com.artillexstudios.axrankmenu.hooks.currency.CurrencyHook;
import java.util.Optional;
import me.TechsCode.UltraEconomy.UltraEconomy;
import me.TechsCode.UltraEconomy.objects.Account;
import me.TechsCode.UltraEconomy.objects.Currency;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class UltraEconomyHook
implements CurrencyHook {
    private Currency currency = null;

    @Override
    public void setup() {
        Optional currencyOptional = UltraEconomy.getAPI().getCurrencies().name(AxRankMenu.CONFIG.getString("hooks.UltraEconomy.currency-name", "coins"));
        if (!currencyOptional.isPresent()) {
            throw new RuntimeException("Currency not found!");
        }
        this.currency = (Currency)currencyOptional.get();
    }

    @Override
    public String getName() {
        return "UltraEconomy";
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public double getBalance(@NotNull Player p) {
        Optional account = UltraEconomy.getAPI().getAccounts().uuid(p.getUniqueId());
        if (!account.isPresent()) {
            return 0.0;
        }
        return ((Account)account.get()).getBalance(this.currency).getOnHand();
    }

    @Override
    public void giveBalance(@NotNull Player p, double amount) {
        Optional account = UltraEconomy.getAPI().getAccounts().uuid(p.getUniqueId());
        if (!account.isPresent()) {
            return;
        }
        ((Account)account.get()).addBalance(this.currency, amount);
    }

    @Override
    public void takeBalance(@NotNull Player p, double amount) {
        Optional account = UltraEconomy.getAPI().getAccounts().uuid(p.getUniqueId());
        if (!account.isPresent()) {
            return;
        }
        ((Account)account.get()).removeBalance(this.currency, amount);
    }
}

