/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.warps;

import com.artillexstudios.axplayerwarps.AxPlayerWarps;
import com.artillexstudios.axplayerwarps.libs.axapi.scheduler.Scheduler;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.Cooldown;
import com.artillexstudios.axplayerwarps.warps.TeleportData;
import com.artillexstudios.axplayerwarps.warps.Warp;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class WarpQueue {
    private static final Map<Player, TeleportData> queue = new WeakHashMap<Player, TeleportData>();
    private static final Cooldown<Player> cooldown = Cooldown.create();

    public static void start() {
        Scheduler.get().runTimer(() -> {
            long time = AxPlayerWarps.CONFIG.getLong("teleport-delay-seconds");
            try {
                Iterator<Map.Entry<Player, TeleportData>> it = queue.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Player, TeleportData> e = it.next();
                    Player player = e.getKey();
                    if (cooldown.hasCooldown(player)) continue;
                    TeleportData teleportData = e.getValue();
                    Warp warp = teleportData.warp();
                    cooldown.addCooldown(e.getKey(), 1000L);
                    long spent = (System.currentTimeMillis() - teleportData.date()) / 1000L;
                    if (spent >= time) {
                        if (!warp.getLocation().equals((Object)teleportData.location()) || warp.getTeleportPrice() != teleportData.teleportPrice() || !Objects.equals(warp.getCurrency(), teleportData.currency())) {
                            AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)player, "errors.warp-changed", new TagResolver[0]);
                        } else {
                            warp.completeTeleportPlayer(e.getKey());
                        }
                        it.remove();
                        continue;
                    }
                    AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)player, "teleport.in", Map.of("%seconds%", "" + (time - spent)));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }, 2L, 2L);
    }

    public static void addToQueue(Player player, Warp warp) {
        queue.put(player, new TeleportData(warp, System.currentTimeMillis(), warp.getLocation(), warp.getCurrency(), warp.getTeleportPrice()));
    }

    public static Map<Player, TeleportData> getQueue() {
        return queue;
    }
}

