/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.utils;

import com.artillexstudios.axplayerwarps.AxPlayerWarps;
import com.artillexstudios.axplayerwarps.utils.SimpleRegex;

public class WarpNameUtils {
    public static ValidationResult isAllowed(String name) {
        if (!AxPlayerWarps.CONFIG.getBoolean("warp-naming.allow-spaces", false) && name.contains(" ")) {
            return ValidationResult.CONTAINS_SPACES;
        }
        if (name.length() < AxPlayerWarps.CONFIG.getInt("warp-naming.length.min", 1) || name.length() > AxPlayerWarps.CONFIG.getInt("warp-naming.length.max", 16)) {
            return ValidationResult.INVALID_LENGTH;
        }
        if (AxPlayerWarps.CONFIG.getBoolean("warp-naming.allowed-characters.enabled", false)) {
            char[] list = AxPlayerWarps.CONFIG.getString("warp-naming.allowed-characters.list", "").toCharArray();
            for (char c1 : name.toCharArray()) {
                boolean found = false;
                for (char c2 : list) {
                    if (c1 != c2) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return ValidationResult.DISALLOWED;
            }
        }
        if (SimpleRegex.matches(AxPlayerWarps.CONFIG.getStringList("warp-naming.disallowed"), name)) {
            return ValidationResult.DISALLOWED;
        }
        return ValidationResult.ALLOWED;
    }

    public static enum ValidationResult {
        ALLOWED,
        CONTAINS_SPACES,
        INVALID_LENGTH,
        DISALLOWED;

    }
}

