/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.libs.lamp.core;

import com.artillexstudios.axplayerwarps.libs.lamp.annotation.NotSender;
import com.artillexstudios.axplayerwarps.libs.lamp.command.CommandActor;
import com.artillexstudios.axplayerwarps.libs.lamp.command.CommandParameter;
import com.artillexstudios.axplayerwarps.libs.lamp.command.ExecutableCommand;
import com.artillexstudios.axplayerwarps.libs.lamp.process.ContextResolver;
import com.artillexstudios.axplayerwarps.libs.lamp.process.ContextResolverFactory;
import com.artillexstudios.axplayerwarps.libs.lamp.process.SenderResolver;
import com.artillexstudios.axplayerwarps.libs.lamp.util.Preconditions;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SenderContextResolverFactory
implements ContextResolverFactory {
    private static final SenderResolver SELF = new SenderResolver(){

        @Override
        public boolean isCustomType(Class<?> type) {
            return CommandActor.class.isAssignableFrom(type);
        }

        @Override
        @NotNull
        public Object getSender(@NotNull Class<?> customSenderType, @NotNull CommandActor actor, @NotNull ExecutableCommand command) {
            return actor;
        }
    };
    private final List<SenderResolver> resolvers;

    public SenderContextResolverFactory(List<SenderResolver> resolvers) {
        this.resolvers = resolvers;
        resolvers.add(SELF);
    }

    private static boolean definitelyNotSender(CommandParameter parameter) {
        return Arrays.stream(parameter.getJavaParameter().getAnnotations()).anyMatch(a2 -> a2.annotationType().isAnnotationPresent(NotSender.ImpliesNotSender.class));
    }

    @Override
    @Nullable
    public ContextResolver<?> create(@NotNull CommandParameter parameter) {
        if (parameter.getMethodIndex() != 0) {
            return null;
        }
        if (SenderContextResolverFactory.definitelyNotSender(parameter)) {
            return null;
        }
        for (SenderResolver resolver : this.resolvers) {
            if (!resolver.isCustomType(parameter.getType())) continue;
            return context -> Preconditions.notNull(resolver.getSender(parameter.getType(), (CommandActor)context.actor(), context.command()), "SenderResolver#getSender() must not return null!");
        }
        return null;
    }
}

