/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.libs.axapi.packet.listeners;

import com.artillexstudios.axplayerwarps.libs.axapi.events.PacketEntityInteractEvent;
import com.artillexstudios.axplayerwarps.libs.axapi.gui.SignInput;
import com.artillexstudios.axplayerwarps.libs.axapi.nms.wrapper.ServerPlayerWrapper;
import com.artillexstudios.axplayerwarps.libs.axapi.packet.ClientboundPacketTypes;
import com.artillexstudios.axplayerwarps.libs.axapi.packet.PacketEvent;
import com.artillexstudios.axplayerwarps.libs.axapi.packet.PacketListener;
import com.artillexstudios.axplayerwarps.libs.axapi.packet.ServerboundPacketTypes;
import com.artillexstudios.axplayerwarps.libs.axapi.packet.wrapper.clientbound.ClientboundAddEntityWrapper;
import com.artillexstudios.axplayerwarps.libs.axapi.packet.wrapper.clientbound.ClientboundBlockUpdateWrapper;
import com.artillexstudios.axplayerwarps.libs.axapi.packet.wrapper.clientbound.ClientboundSetPassengersWrapper;
import com.artillexstudios.axplayerwarps.libs.axapi.packet.wrapper.serverbound.ServerboundInteractWrapper;
import com.artillexstudios.axplayerwarps.libs.axapi.packet.wrapper.serverbound.ServerboundSignUpdateWrapper;
import com.artillexstudios.axplayerwarps.libs.axapi.packetentity.PacketEntity;
import com.artillexstudios.axplayerwarps.libs.axapi.packetentity.tracker.EntityTracker;
import com.artillexstudios.axplayerwarps.libs.axapi.scheduler.Scheduler;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.Vector3f;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.featureflags.FeatureFlags;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public final class BuiltinPacketListener
extends PacketListener {
    private final EntityTracker tracker;

    public BuiltinPacketListener(EntityTracker tracker) {
        this.tracker = tracker;
    }

    @Override
    public void onPacketSending(PacketEvent event) {
        if (event.type() == ClientboundPacketTypes.ADD_ENTITY && ((Boolean)FeatureFlags.LISTEN_TO_RIDE_PACKET.get()).booleanValue()) {
            if (this.tracker == null) {
                return;
            }
            ClientboundAddEntityWrapper wrapper = new ClientboundAddEntityWrapper(event);
            int entityId = wrapper.getEntityId();
            PacketEntity rider = this.tracker.findRider(entityId);
            if (rider == null) {
                return;
            }
            ClientboundSetPassengersWrapper passengersWrapper = new ClientboundSetPassengersWrapper(entityId, new int[]{rider.id()});
            ServerPlayerWrapper serverPlayerWrapper = ServerPlayerWrapper.wrap(event.player());
            serverPlayerWrapper.sendPacket(passengersWrapper);
        }
    }

    @Override
    public void onPacketReceive(PacketEvent event) {
        if (event.type() == ServerboundPacketTypes.INTERACT) {
            if (this.tracker == null) {
                return;
            }
            ServerboundInteractWrapper wrapper = new ServerboundInteractWrapper(event);
            PacketEntity entity = this.tracker.getById(wrapper.entityId());
            if (entity != null) {
                ServerboundInteractWrapper.InteractionHand interactionHand;
                Vector3f vector3f;
                Player player = event.player();
                boolean bl = wrapper.type() == ServerboundInteractWrapper.ActionType.ATTACK;
                ServerboundInteractWrapper.Action action = wrapper.action();
                if (action instanceof ServerboundInteractWrapper.InteractionAtLocationAction) {
                    ServerboundInteractWrapper.InteractionAtLocationAction action2 = (ServerboundInteractWrapper.InteractionAtLocationAction)action;
                    vector3f = action2.location();
                } else {
                    vector3f = null;
                }
                ServerboundInteractWrapper.Action action3 = wrapper.action();
                if (action3 instanceof ServerboundInteractWrapper.InteractionAction) {
                    ServerboundInteractWrapper.InteractionAction action4 = (ServerboundInteractWrapper.InteractionAction)action3;
                    interactionHand = action4.hand();
                } else {
                    action3 = wrapper.action();
                    if (action3 instanceof ServerboundInteractWrapper.InteractionAtLocationAction) {
                        ServerboundInteractWrapper.InteractionAtLocationAction interaction = (ServerboundInteractWrapper.InteractionAtLocationAction)action3;
                        interactionHand = interaction.hand();
                    } else {
                        interactionHand = null;
                    }
                }
                PacketEntityInteractEvent interactEvent = new PacketEntityInteractEvent(player, entity, bl, vector3f, interactionHand);
                Bukkit.getPluginManager().callEvent((Event)interactEvent);
            }
        } else if (event.type() == ServerboundPacketTypes.SIGN_UPDATE) {
            ServerboundSignUpdateWrapper wrapper = new ServerboundSignUpdateWrapper(event);
            SignInput signInput = SignInput.remove(event.player());
            if (signInput == null) {
                return;
            }
            signInput.getListener().accept(event.player(), wrapper.lines());
            Scheduler.get().runAt(signInput.getLocation(), task -> {
                ServerPlayerWrapper playerWrapper = ServerPlayerWrapper.wrap(event.player());
                playerWrapper.sendPacket(new ClientboundBlockUpdateWrapper(signInput.getLocation(), signInput.getLocation().getBlock().getType()));
            });
        }
    }
}

