/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.libs.axapi.metrics.collectors.implementation;

import com.artillexstudios.axplayerwarps.libs.axapi.metrics.collectors.MetricsCollector;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.logging.LogUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Method;

public final class OperatingSystemMetricsCollector
implements MetricsCollector {
    private String operatingSystem;

    public OperatingSystemMetricsCollector(Object systemInfo) {
        try {
            Method operatingSystemGetter = Class.forName("oshi.SystemInfo").getDeclaredMethod("getOperatingSystem", new Class[0]);
            Object operatingSystem = operatingSystemGetter.invoke(systemInfo, new Object[0]);
            Method operatingSystemVersionGetter = Class.forName("oshi.software.os.OperatingSystem").getDeclaredMethod("getVersionInfo", new Class[0]);
            this.operatingSystem = operatingSystemVersionGetter.invoke(operatingSystem, new Object[0]).toString() + "|" + System.getProperty("os.name");
        }
        catch (Exception exception) {
            LogUtils.error("Failed to load OperatingSystem type!", new Object[0]);
        }
    }

    @Override
    public void collect(JsonArray data) {
        if (this.operatingSystem == null) {
            return;
        }
        JsonObject object = new JsonObject();
        object.addProperty("@type", "operating-system");
        object.addProperty("operating-system", this.operatingSystem);
        data.add((JsonElement)object);
    }
}

