/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.hooks.currency;

import com.artillexstudios.axplayerwarps.hooks.currency.CurrencyHook;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.StringUtils;
import java.util.UUID;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.coinsengine.api.CoinsEngineAPI;
import su.nightexpress.coinsengine.api.currency.Currency;

public class CoinsEngineHook
implements CurrencyHook {
    private Currency currency = null;
    private final String internal;
    private final String name;

    public CoinsEngineHook(String internal, String name) {
        this.internal = internal;
        this.name = name;
    }

    @Override
    public void setup() {
        this.currency = CoinsEngineAPI.getCurrency((String)this.internal);
        if (this.currency == null) {
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF0000[AxPlayerWarps] CoinsEngine currency named &#DD0000" + this.internal + " &#FF0000not found! Change the currency-name or disable the hook to get rid of this warning!", new TagResolver[0]));
        }
    }

    @Override
    public String getName() {
        return "CoinsEngine-" + this.internal;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public boolean worksOffline() {
        return false;
    }

    @Override
    public boolean usesDouble() {
        return true;
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public double getBalance(@NotNull UUID player) {
        if (this.currency == null) {
            return 0.0;
        }
        return CoinsEngineAPI.getBalance((Player)Bukkit.getPlayer((UUID)player), (Currency)this.currency);
    }

    @Override
    public void giveBalance(@NotNull UUID player, double amount) {
        if (this.currency == null) {
            return;
        }
        CoinsEngineAPI.addBalance((Player)Bukkit.getPlayer((UUID)player), (Currency)this.currency, (double)amount);
    }

    @Override
    public void takeBalance(@NotNull UUID player, double amount) {
        if (this.currency == null) {
            return;
        }
        CoinsEngineAPI.removeBalance((Player)Bukkit.getPlayer((UUID)player), (Currency)this.currency, (double)amount);
    }
}

