/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.hooks;

import com.artillexstudios.axplayerwarps.AxPlayerWarps;
import com.artillexstudios.axplayerwarps.hooks.currency.AxQuestBoardHook;
import com.artillexstudios.axplayerwarps.hooks.currency.BeastTokensHook;
import com.artillexstudios.axplayerwarps.hooks.currency.CoinsEngineHook;
import com.artillexstudios.axplayerwarps.hooks.currency.CurrencyHook;
import com.artillexstudios.axplayerwarps.hooks.currency.EcoBitsHook;
import com.artillexstudios.axplayerwarps.hooks.currency.ExperienceHook;
import com.artillexstudios.axplayerwarps.hooks.currency.KingdomsXHook;
import com.artillexstudios.axplayerwarps.hooks.currency.PlaceholderCurrencyHook;
import com.artillexstudios.axplayerwarps.hooks.currency.PlayerPointsHook;
import com.artillexstudios.axplayerwarps.hooks.currency.RedisEconomyHook;
import com.artillexstudios.axplayerwarps.hooks.currency.RivalHarvesterHoesHook;
import com.artillexstudios.axplayerwarps.hooks.currency.RoyaleEconomyHook;
import com.artillexstudios.axplayerwarps.hooks.currency.SuperMobCoinsHook;
import com.artillexstudios.axplayerwarps.hooks.currency.TheOnlyMobCoins;
import com.artillexstudios.axplayerwarps.hooks.currency.TokenManagerHook;
import com.artillexstudios.axplayerwarps.hooks.currency.UltraEconomyHook;
import com.artillexstudios.axplayerwarps.hooks.currency.VaultHook;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.StringUtils;
import com.artillexstudios.axplayerwarps.libs.axintegrations.AxIntegrations;
import com.artillexstudios.axplayerwarps.libs.axintegrations.integration.protection.ProtectionIntegration;
import com.artillexstudios.axplayerwarps.libs.axintegrations.integration.protection.ProtectionIntegrations;
import java.util.ArrayList;
import java.util.Map;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HookManager {
    private static final ArrayList<CurrencyHook> currency = new ArrayList();

    public static void setupHooks() {
        HookManager.updateHooks();
    }

    public static void updateHooks() {
        currency.removeIf(currencyHook -> !currencyHook.isPersistent());
        ProtectionIntegrations.values().clear();
        AxIntegrations.INSTANCE.init();
        ProtectionIntegrations.values().removeIf(integration -> !AxPlayerWarps.HOOKS.getBoolean("hooks.protection." + integration.id(), false));
        boolean modified = false;
        for (ProtectionIntegration protectionIntegration : ProtectionIntegrations.values()) {
            if (AxPlayerWarps.HOOKS.getString("hooks.protection." + protectionIntegration.id(), null) == null) {
                modified = true;
                AxPlayerWarps.HOOKS.set("hooks.protection." + protectionIntegration.id(), true);
            }
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxPlayerWarps] Hooked into " + protectionIntegration.id() + "!", new TagResolver[0]));
        }
        if (modified) {
            AxPlayerWarps.HOOKS.save();
        }
        if (AxPlayerWarps.CURRENCIES.getBoolean("currencies.Experience.register", true)) {
            currency.add(new ExperienceHook());
        }
        if (AxPlayerWarps.CURRENCIES.getBoolean("currencies.Vault.register", true) && Bukkit.getPluginManager().getPlugin("Vault") != null) {
            currency.add(new VaultHook());
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxPlayerWarps] Hooked into Vault!", new TagResolver[0]));
        }
        if (AxPlayerWarps.CURRENCIES.getBoolean("currencies.PlayerPoints.register", true) && Bukkit.getPluginManager().getPlugin("PlayerPoints") != null) {
            currency.add(new PlayerPointsHook());
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxPlayerWarps] Hooked into PlayerPoints!", new TagResolver[0]));
        }
        if (AxPlayerWarps.CURRENCIES.getBoolean("currencies.CoinsEngine.register", true) && Bukkit.getPluginManager().getPlugin("CoinsEngine") != null) {
            for (Map map : AxPlayerWarps.CURRENCIES.getMapList("currencies.CoinsEngine.enabled")) {
                currency.add(new CoinsEngineHook((String)map.get("currency-name"), (String)map.get("name")));
            }
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxPlayerWarps] Hooked into CoinsEngine!", new TagResolver[0]));
        }
        if (AxPlayerWarps.CURRENCIES.getBoolean("currencies.RoyaleEconomy.register", true) && Bukkit.getPluginManager().getPlugin("RoyaleEconomy") != null) {
            currency.add(new RoyaleEconomyHook());
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxPlayerWarps] Hooked into RoyaleEconomy!", new TagResolver[0]));
        }
        if (AxPlayerWarps.CURRENCIES.getBoolean("currencies.UltraEconomy.register", true) && Bukkit.getPluginManager().getPlugin("UltraEconomy") != null) {
            for (Map map : AxPlayerWarps.CURRENCIES.getMapList("currencies.UltraEconomy.enabled")) {
                currency.add(new UltraEconomyHook((String)map.get("currency-name"), (String)map.get("name")));
            }
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxPlayerWarps] Hooked into UltraEconomy!", new TagResolver[0]));
        }
        if (AxPlayerWarps.CURRENCIES.getBoolean("currencies.KingdomsX.register", true) && Bukkit.getPluginManager().getPlugin("Kingdoms") != null) {
            currency.add(new KingdomsXHook());
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxPlayerWarps] Hooked into KingdomsX!", new TagResolver[0]));
        }
        if (AxPlayerWarps.CURRENCIES.getBoolean("currencies.RivalHarvesterHoes.register", true) && Bukkit.getPluginManager().getPlugin("RivalHarvesterHoes") != null) {
            currency.add(new RivalHarvesterHoesHook());
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxPlayerWarps] Hooked into RivalHarvesterHoes!", new TagResolver[0]));
        }
        if (AxPlayerWarps.CURRENCIES.getBoolean("currencies.SuperMobCoins.register", true) && Bukkit.getPluginManager().getPlugin("SuperMobCoins") != null) {
            currency.add(new SuperMobCoinsHook());
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxPlayerWarps] Hooked into SuperMobCoins!", new TagResolver[0]));
        }
        if (AxPlayerWarps.CURRENCIES.getBoolean("currencies.TheOnly-MobCoins.register", true) && Bukkit.getPluginManager().getPlugin("TheOnly-MobCoins") != null) {
            currency.add(new TheOnlyMobCoins());
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxPlayerWarps] Hooked into TheOnly-MobCoins!", new TagResolver[0]));
        }
        if (AxPlayerWarps.CURRENCIES.getBoolean("currencies.TokenManager.register", true) && Bukkit.getPluginManager().getPlugin("TokenManager") != null) {
            currency.add(new TokenManagerHook());
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxPlayerWarps] Hooked into TokenManager!", new TagResolver[0]));
        }
        if (AxPlayerWarps.CURRENCIES.getBoolean("currencies.AxQuestBoard.register", true) && Bukkit.getPluginManager().getPlugin("AxQuestBoard") != null) {
            currency.add(new AxQuestBoardHook());
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxPlayerWarps] Hooked into AxQuestBoard!", new TagResolver[0]));
        }
        if (AxPlayerWarps.CURRENCIES.getBoolean("currencies.RedisEconomy.register", true) && Bukkit.getPluginManager().getPlugin("RedisEconomy") != null) {
            for (Map map : AxPlayerWarps.CURRENCIES.getMapList("currencies.RedisEconomy.enabled")) {
                currency.add(new RedisEconomyHook((String)map.get("currency-name"), (String)map.get("name")));
            }
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxPlayerWarps] Hooked into RedisEconomy!", new TagResolver[0]));
        }
        if (AxPlayerWarps.CURRENCIES.getBoolean("currencies.BeastTokens.register", true) && Bukkit.getPluginManager().getPlugin("BeastTokens") != null) {
            currency.add(new BeastTokensHook());
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxPlayerWarps] Hooked into BeastTokens!", new TagResolver[0]));
        }
        if (AxPlayerWarps.CURRENCIES.getBoolean("currencies.EcoBits.register", true) && Bukkit.getPluginManager().getPlugin("EcoBits") != null) {
            for (Map map : AxPlayerWarps.CURRENCIES.getMapList("currencies.EcoBits.enabled")) {
                currency.add(new EcoBitsHook((String)map.get("currency-name"), (String)map.get("name")));
            }
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxPlayerWarps] Hooked into EcoBits!", new TagResolver[0]));
        }
        for (String string : AxPlayerWarps.CURRENCIES.getSection("placeholder-currencies").getRoutesAsStrings(false)) {
            if (!AxPlayerWarps.CURRENCIES.getBoolean("placeholder-currencies." + string + ".register", false)) continue;
            currency.add(new PlaceholderCurrencyHook(string, AxPlayerWarps.CURRENCIES.getSection("placeholder-currencies." + string)));
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxPlayerWarps] Loaded placeholder currency " + string + "!", new TagResolver[0]));
        }
        for (CurrencyHook currencyHook2 : currency) {
            currencyHook2.setup();
        }
    }

    public static void registerCurrencyHook(@NotNull Plugin plugin, @NotNull CurrencyHook currencyHook) {
        currency.add(currencyHook);
        Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxPlayerWarps] Hooked into " + plugin.getName() + "! Note: You must set the currency provider to CUSTOM or it will be overridden after reloading!", new TagResolver[0]));
    }

    @NotNull
    public static ArrayList<CurrencyHook> getCurrency() {
        return currency;
    }

    @Nullable
    public static CurrencyHook getCurrencyHook(@NotNull String name) {
        for (CurrencyHook hook : currency) {
            if (!hook.getName().equals(name)) continue;
            return hook;
        }
        return null;
    }

    public static boolean canBuild(Player player, Location location) {
        for (ProtectionIntegration integration : ProtectionIntegrations.values()) {
            if (integration.canBuild(player, location)) continue;
            return false;
        }
        return true;
    }
}

