/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.database.impl;

import com.artillexstudios.axplayerwarps.AxPlayerWarps;
import com.artillexstudios.axplayerwarps.database.impl.Base;
import com.artillexstudios.axplayerwarps.libs.hikari.HikariConfig;
import com.artillexstudios.axplayerwarps.libs.hikari.HikariDataSource;
import java.sql.Connection;

public class PostgreSQL
extends Base {
    private HikariDataSource dataSource;

    @Override
    public Connection getConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public String getType() {
        return "PostgreSQL";
    }

    @Override
    public void setup() {
        HikariConfig hConfig = new HikariConfig();
        hConfig.setPoolName("axplayerwarps-pool");
        hConfig.setMaximumPoolSize(AxPlayerWarps.CONFIG.getInt("database.pool.maximum-pool-size"));
        hConfig.setMinimumIdle(AxPlayerWarps.CONFIG.getInt("database.pool.minimum-idle"));
        hConfig.setMaxLifetime((long)AxPlayerWarps.CONFIG.getInt("database.pool.maximum-lifetime"));
        hConfig.setKeepaliveTime((long)AxPlayerWarps.CONFIG.getInt("database.pool.keepalive-time"));
        hConfig.setConnectionTimeout((long)AxPlayerWarps.CONFIG.getInt("database.pool.connection-timeout"));
        hConfig.setDriverClassName("com.artillexstudios.axplayerwarps.libs.postgresql.Driver");
        hConfig.setJdbcUrl("jdbc:postgresql://" + AxPlayerWarps.CONFIG.getString("database.address") + ":" + AxPlayerWarps.CONFIG.getString("database.port") + "/" + AxPlayerWarps.CONFIG.getString("database.database"));
        hConfig.addDataSourceProperty("user", (Object)AxPlayerWarps.CONFIG.getString("database.username"));
        hConfig.addDataSourceProperty("password", (Object)AxPlayerWarps.CONFIG.getString("database.password"));
        this.dataSource = new HikariDataSource(hConfig);
        super.setup();
    }

    @Override
    public void disable() {
        try {
            this.dataSource.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

