/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps;

import com.artillexstudios.axplayerwarps.category.CategoryManager;
import com.artillexstudios.axplayerwarps.commands.CommandManager;
import com.artillexstudios.axplayerwarps.database.Database;
import com.artillexstudios.axplayerwarps.database.impl.H2;
import com.artillexstudios.axplayerwarps.database.impl.MySQL;
import com.artillexstudios.axplayerwarps.database.impl.PostgreSQL;
import com.artillexstudios.axplayerwarps.guis.BlacklistGui;
import com.artillexstudios.axplayerwarps.guis.CategoryGui;
import com.artillexstudios.axplayerwarps.guis.EditWarpGui;
import com.artillexstudios.axplayerwarps.guis.FavoritesGui;
import com.artillexstudios.axplayerwarps.guis.MyWarpsGui;
import com.artillexstudios.axplayerwarps.guis.RateWarpGui;
import com.artillexstudios.axplayerwarps.guis.RecentsGui;
import com.artillexstudios.axplayerwarps.guis.WarpsGui;
import com.artillexstudios.axplayerwarps.guis.WhitelistGui;
import com.artillexstudios.axplayerwarps.hooks.HookManager;
import com.artillexstudios.axplayerwarps.input.InputListener;
import com.artillexstudios.axplayerwarps.libraries.Libraries;
import com.artillexstudios.axplayerwarps.libs.axapi.AxPlugin;
import com.artillexstudios.axplayerwarps.libs.axapi.config.Config;
import com.artillexstudios.axplayerwarps.libs.axapi.dependencies.DependencyManagerWrapper;
import com.artillexstudios.axplayerwarps.libs.axapi.executor.ThreadedQueue;
import com.artillexstudios.axplayerwarps.libs.axapi.libs.boostedyaml.dvs.versioning.BasicVersioning;
import com.artillexstudios.axplayerwarps.libs.axapi.libs.boostedyaml.settings.dumper.DumperSettings;
import com.artillexstudios.axplayerwarps.libs.axapi.libs.boostedyaml.settings.general.GeneralSettings;
import com.artillexstudios.axplayerwarps.libs.axapi.libs.boostedyaml.settings.loader.LoaderSettings;
import com.artillexstudios.axplayerwarps.libs.axapi.libs.boostedyaml.settings.updater.UpdaterSettings;
import com.artillexstudios.axplayerwarps.libs.axapi.metrics.AxMetrics;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.AsyncUtils;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.MessageUtils;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.StringUtils;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.featureflags.FeatureFlags;
import com.artillexstudios.axplayerwarps.libs.bstats.bukkit.Metrics;
import com.artillexstudios.axplayerwarps.libs.gui.GuiManager;
import com.artillexstudios.axplayerwarps.listeners.MoveListener;
import com.artillexstudios.axplayerwarps.listeners.PlayerListeners;
import com.artillexstudios.axplayerwarps.listeners.WorldListeners;
import com.artillexstudios.axplayerwarps.placeholders.WarpPlaceholders;
import com.artillexstudios.axplayerwarps.sorting.SortingManager;
import com.artillexstudios.axplayerwarps.utils.UpdateNotifier;
import com.artillexstudios.axplayerwarps.warps.WarpManager;
import com.artillexstudios.axplayerwarps.warps.WarpQueue;
import com.artillexstudios.axplayerwarps.world.WorldManager;
import java.io.File;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import revxrsal.zapper.DependencyManager;
import revxrsal.zapper.relocation.Relocation;

public final class AxPlayerWarps
extends AxPlugin {
    private static AxPlugin instance;
    private static ThreadedQueue<Runnable> threadedQueue;
    private static Database database;
    public static MessageUtils MESSAGEUTILS;
    public static Config CONFIG;
    public static Config HOOKS;
    public static Config LANG;
    public static Config CURRENCIES;
    public static Config INPUT;
    private static AxMetrics metrics;

    public static ThreadedQueue<Runnable> getThreadedQueue() {
        return threadedQueue;
    }

    public static Database getDatabase() {
        return database;
    }

    public static AxPlugin getInstance() {
        return instance;
    }

    @Override
    public void dependencies(DependencyManagerWrapper manager) {
        instance = this;
        manager.repository("https://jitpack.io/");
        manager.repository("https://repo.codemc.org/repository/maven-public/");
        manager.repository("https://repo.papermc.io/repository/maven-public/");
        manager.repository("https://repo.artillex-studios.com/releases/");
        DependencyManager dependencyManager = manager.wrapped();
        for (Libraries lib : Libraries.values()) {
            dependencyManager.dependency(lib.fetchLibrary());
            for (Relocation relocation : lib.relocations()) {
                dependencyManager.relocate(relocation);
            }
        }
    }

    @Override
    public void enable() {
        new Metrics((Plugin)this, 21645);
        instance = this;
        CONFIG = new Config(new File(this.getDataFolder(), "config.yml"), this.getResource("config.yml"), GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setVersioning(new BasicVersioning("version")).build());
        HOOKS = new Config(new File(this.getDataFolder(), "hooks.yml"), this.getResource("hooks.yml"), GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setVersioning(new BasicVersioning("version")).build());
        LANG = new Config(new File(this.getDataFolder(), "lang.yml"), this.getResource("lang.yml"), GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setKeepAll(true).setVersioning(new BasicVersioning("version")).build());
        CURRENCIES = new Config(new File(this.getDataFolder(), "currencies.yml"), this.getResource("currencies.yml"), GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setKeepAll(true).setVersioning(new BasicVersioning("version")).build());
        INPUT = new Config(new File(this.getDataFolder(), "input.yml"), this.getResource("input.yml"), GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setKeepAll(true).setVersioning(new BasicVersioning("version")).build());
        threadedQueue = new ThreadedQueue("AxPlayerWarps-Datastore-thread");
        MESSAGEUTILS = new MessageUtils(LANG.getBackingDocument(), "prefix", CONFIG.getBackingDocument());
        CategoryGui.reload();
        GuiManager.registerGuiType("categories", CategoryGui.class);
        WarpsGui.reload();
        GuiManager.registerGuiType("warps", WarpsGui.class);
        RateWarpGui.reload();
        EditWarpGui.reload();
        FavoritesGui.reload();
        GuiManager.registerGuiType("favorites", FavoritesGui.class);
        RecentsGui.reload();
        GuiManager.registerGuiType("recents", RecentsGui.class);
        MyWarpsGui.reload();
        GuiManager.registerGuiType("my-warps", MyWarpsGui.class);
        WhitelistGui.reload();
        BlacklistGui.reload();
        WarpPlaceholders.load();
        switch (CONFIG.getString("database.type").toLowerCase()) {
            case "mysql": {
                database = new MySQL();
                break;
            }
            case "postgresql": {
                database = new PostgreSQL();
                break;
            }
            default: {
                database = new H2();
            }
        }
        database.setup();
        HookManager.setupHooks();
        WorldManager.reload();
        CategoryManager.reload();
        SortingManager.reload();
        CommandManager.load();
        WarpManager.load();
        WarpQueue.start();
        this.getServer().getPluginManager().registerEvents((Listener)new WorldListeners(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListeners(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new MoveListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new InputListener(), (Plugin)this);
        metrics = new AxMetrics(this, 17L);
        metrics.start();
        Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#44f1d7[AxPlayerWarps] Loaded plugin! Using &f" + database.getType() + " &#44f1d7database to store data!", new TagResolver[0]));
        if (CONFIG.getBoolean("update-notifier.enabled", true)) {
            new UpdateNotifier(this, 6657);
        }
    }

    @Override
    public void disable() {
        if (metrics != null) {
            metrics.cancel();
        }
        database.disable();
        AsyncUtils.stop();
    }

    @Override
    public void updateFlags() {
        FeatureFlags.USE_LEGACY_HEX_FORMATTER.set(true);
        FeatureFlags.ASYNC_UTILS_POOL_SIZE.set(3);
        FeatureFlags.ENABLE_PACKET_LISTENERS.set(true);
        FeatureFlags.PLACEHOLDER_API_HOOK.set(true);
        FeatureFlags.PLACEHOLDER_API_IDENTIFIER.set("axplayerwarps");
    }
}

