/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.warps;

import com.artillexstudios.axplayerwarps.AxPlayerWarps;
import com.artillexstudios.axplayerwarps.category.Category;
import com.artillexstudios.axplayerwarps.database.impl.Base;
import com.artillexstudios.axplayerwarps.enums.Access;
import com.artillexstudios.axplayerwarps.enums.AccessList;
import com.artillexstudios.axplayerwarps.hooks.currency.CurrencyHook;
import com.artillexstudios.axplayerwarps.libs.axapi.placeholders.PlaceholderHandler;
import com.artillexstudios.axplayerwarps.libs.axapi.scheduler.Scheduler;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.Cooldown;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.PaperUtils;
import com.artillexstudios.axplayerwarps.placeholders.WarpPlaceholders;
import com.artillexstudios.axplayerwarps.warps.WarpQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class Warp {
    private final int id;
    private UUID owner;
    private String ownerName;
    private Location location;
    private String name;
    @Nullable
    private String description;
    @Nullable
    private Category category;
    private final long created;
    private Access access;
    @Nullable
    private CurrencyHook currency;
    private double teleportPrice;
    private double earnedMoney;
    private Material icon;
    private int favorites;
    private HashMap<UUID, Integer> rating = new HashMap();
    private int visits;
    private HashSet<UUID> visitors = new HashSet();
    private List<Base.AccessPlayer> whitelisted = Collections.synchronizedList(new ArrayList());
    private List<Base.AccessPlayer> blacklisted = Collections.synchronizedList(new ArrayList());
    private String worldName;
    private final Cooldown<Player> confirmUnsafe = Cooldown.create();
    private final Cooldown<Player> confirmPaid = Cooldown.create();

    public Warp(int id, long created, @Nullable String description, String name, Location location, String worldName, @Nullable Category category, UUID owner, String ownerName, Access access, @Nullable CurrencyHook currency, double teleportPrice, double earnedMoney, @Nullable Material icon) {
        location.setX((double)location.getBlockX());
        location.setY((double)location.getBlockY());
        location.setZ((double)location.getBlockZ());
        location.add(0.5, 0.0, 0.5);
        this.id = id;
        this.created = created;
        this.description = description;
        this.name = name;
        this.location = location;
        this.worldName = worldName;
        this.category = category;
        this.owner = owner;
        this.ownerName = ownerName;
        this.access = access;
        this.currency = currency;
        this.teleportPrice = teleportPrice;
        this.earnedMoney = earnedMoney;
        this.icon = icon;
        AxPlayerWarps.getThreadedQueue().submit(() -> {
            this.favorites = AxPlayerWarps.getDatabase().getFavorites(this);
            this.rating = AxPlayerWarps.getDatabase().getAllRatings(this);
            this.visits = AxPlayerWarps.getDatabase().getVisits(this);
            this.visitors = AxPlayerWarps.getDatabase().getVisitors(this);
            this.whitelisted = AxPlayerWarps.getDatabase().getAccessList(this, AccessList.WHITELIST);
            this.blacklisted = AxPlayerWarps.getDatabase().getAccessList(this, AccessList.BLACKLIST);
        });
    }

    public void reload() {
    }

    public int getId() {
        return this.id;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public String getName() {
        return this.name;
    }

    public boolean setName(String name) {
        if (AxPlayerWarps.getDatabase().warpExists(name)) {
            return false;
        }
        this.name = name;
        return true;
    }

    public String getDescription() {
        if (this.description == null) {
            return AxPlayerWarps.CONFIG.getString("warp-description.default", "");
        }
        return this.description;
    }

    @Nullable
    public String getRealDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public void setDescription(List<String> description) {
        String newDesc = String.join((CharSequence)"\n", description);
        this.description = newDesc.isBlank() ? null : newDesc;
    }

    @Nullable
    public Category getCategory() {
        return this.category;
    }

    public void setCategory(@Nullable Category category) {
        this.category = category;
    }

    public long getCreated() {
        return this.created;
    }

    public Access getAccess() {
        return this.access;
    }

    public void setAccess(Access access) {
        this.access = access;
    }

    @Nullable
    public CurrencyHook getCurrency() {
        return this.currency;
    }

    public void setCurrency(@Nullable CurrencyHook currency) {
        this.currency = currency;
    }

    public double getTeleportPrice() {
        return this.teleportPrice;
    }

    public void setTeleportPrice(double teleportPrice) {
        this.teleportPrice = teleportPrice;
    }

    public double getEarnedMoney() {
        return this.earnedMoney;
    }

    public void setEarnedMoney(double earnedMoney) {
        this.earnedMoney = earnedMoney;
    }

    public Material getIcon() {
        if (this.icon == null) {
            return Material.matchMaterial((String)AxPlayerWarps.CONFIG.getString("default-material", "PLAYER_HEAD"));
        }
        return this.icon;
    }

    public void setIcon(Material icon) {
        this.icon = icon;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public int getFavorites() {
        return this.favorites;
    }

    public void setFavorites(int favorites) {
        this.favorites = favorites;
    }

    public HashMap<UUID, Integer> getAllRatings() {
        return this.rating;
    }

    public float getRating() {
        return (float)this.rating.values().stream().mapToDouble(Integer::doubleValue).average().orElse(0.0);
    }

    public int getRatingAmount() {
        return this.rating.size();
    }

    public void setRating(HashMap<UUID, Integer> rating) {
        this.rating = rating;
    }

    public int getVisits() {
        return this.visits;
    }

    public void setVisits(int visits) {
        this.visits = visits;
    }

    public HashSet<UUID> getVisitors() {
        return this.visitors;
    }

    public int getUniqueVisits() {
        return this.visitors.size();
    }

    public List<Base.AccessPlayer> getBlacklisted() {
        return this.blacklisted;
    }

    public List<Base.AccessPlayer> getWhitelisted() {
        return this.whitelisted;
    }

    public List<Base.AccessPlayer> getAccessList(AccessList al) {
        return al == AccessList.WHITELIST ? this.whitelisted : this.blacklisted;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public boolean isPaid() {
        return this.currency != null && this.teleportPrice > 0.0;
    }

    public CompletableFuture<Boolean> isDangerous() {
        if (!AxPlayerWarps.CONFIG.getBoolean("check-unsafe-warps", true)) {
            return CompletableFuture.completedFuture(false);
        }
        return PaperUtils.getChunkAtAsync(this.location).thenApply(chunk -> {
            int x = this.location.getBlockX() & 0xF;
            int y = this.location.getBlockY();
            int z = this.location.getBlockZ() & 0xF;
            Block at = chunk.getBlock(x, y, z);
            Block under = at.getRelative(BlockFace.DOWN);
            Block above = at.getRelative(BlockFace.UP);
            if (!at.getType().isAir()) {
                return true;
            }
            if (!above.getType().isAir()) {
                return true;
            }
            if (!under.getType().isSolid()) {
                return true;
            }
            return false;
        });
    }

    public void teleportPlayer(Player player) {
        this.validateTeleport(player, false, bool -> {
            if (!bool.booleanValue()) {
                return;
            }
            if (player.hasPermission("axplayerwarps.delay-bypass")) {
                this.completeTeleportPlayer(player);
                return;
            }
            Scheduler.get().runAt(player.getLocation(), () -> ((Player)player).closeInventory());
            WarpQueue.addToQueue(player, this);
        });
    }

    public void validateTeleport(Player player, boolean noConfirm, Consumer<Boolean> response) {
        if (!this.location.isWorldLoaded()) {
            World world = Bukkit.getWorld((String)this.worldName);
            if (world == null) {
                AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)player, "errors.invalid-world", new TagResolver[0]);
                response.accept(false);
                return;
            }
            this.location.setWorld(world);
        }
        if (player.hasPermission("axplayerwarps.admin.bypass")) {
            response.accept(true);
            return;
        }
        boolean isOwner = player.getUniqueId().equals(this.owner);
        if (!isOwner && this.isPaid() && !this.confirmPaid.hasCooldown(player)) {
            this.confirmPaid.addCooldown(player, AxPlayerWarps.CONFIG.getLong("confirmation-milliseconds"));
            AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)player, "confirm.paid", Map.of("%warp%", this.getName(), "%price%", this.currency.getDisplayName().replace("%price%", WarpPlaceholders.format(this.teleportPrice))));
            response.accept(false);
            return;
        }
        this.isDangerous().thenAccept(dangerous -> {
            if (!noConfirm) {
                if (dangerous.booleanValue() && !this.confirmUnsafe.hasCooldown(player)) {
                    this.confirmUnsafe.addCooldown(player, AxPlayerWarps.CONFIG.getLong("confirmation-milliseconds"));
                    AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)player, "confirm.unsafe", Map.of("%warp%", this.getName()));
                    response.accept(false);
                    return;
                }
                if (this.access == Access.PRIVATE && !isOwner) {
                    AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)player, "errors.private", Map.of("%warp%", this.getName()));
                    response.accept(false);
                    return;
                }
            }
            if (this.blacklisted.stream().anyMatch(accessPlayer -> accessPlayer.player().equals((Object)player))) {
                AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)player, "errors.blacklisted", Map.of("%warp%", this.getName()));
                response.accept(false);
                return;
            }
            if (this.access == Access.WHITELISTED && !isOwner && this.whitelisted.stream().noneMatch(accessPlayer -> accessPlayer.player().equals((Object)player))) {
                AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)player, "errors.whitelisted", Map.of("%warp%", this.getName()));
                response.accept(false);
                return;
            }
            if (!isOwner && this.isPaid() && this.currency.getBalance(player.getUniqueId()) < this.teleportPrice) {
                AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)player, "errors.not-enough-balance", new TagResolver[0]);
                response.accept(false);
                return;
            }
            response.accept(true);
        });
    }

    public void completeTeleportPlayer(Player player) {
        this.validateTeleport(player, true, bool -> {
            if (!bool.booleanValue()) {
                return;
            }
            player.closeInventory();
            boolean isOwner = player.getUniqueId().equals(this.owner);
            if (!isOwner && this.isPaid()) {
                this.currency.takeBalance(player.getUniqueId(), this.teleportPrice);
                this.earnedMoney += this.teleportPrice;
                AxPlayerWarps.getThreadedQueue().submit(() -> AxPlayerWarps.getDatabase().updateWarp(this));
                AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)player, "money.take", Map.of("%price%", this.currency.getDisplayName().replace("%price%", WarpPlaceholders.format(this.teleportPrice))));
            }
            AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)player, "teleport.success", Map.of("%warp%", this.getName()));
            this.confirmUnsafe.remove(player);
            this.confirmPaid.remove(player);
            PaperUtils.teleportAsync((Entity)player, this.location);
            for (String m : AxPlayerWarps.CONFIG.getStringList("teleport-commands")) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)PlaceholderHandler.parse(m.replace("%player%", player.getName()), this, player));
            }
            AxPlayerWarps.getThreadedQueue().submit(() -> AxPlayerWarps.getDatabase().addVisit(player, this));
        });
    }

    public void delete() {
        Player player = Bukkit.getPlayer((UUID)this.owner);
        AxPlayerWarps.getThreadedQueue().submit(() -> {
            AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)player, "delete.deleted", Map.of("%warp%", this.getName()));
            AxPlayerWarps.getDatabase().deleteWarp(this);
        });
    }

    public void withdrawMoney() {
        Player player = Bukkit.getPlayer((UUID)this.owner);
        if (this.earnedMoney <= 0.0 || this.currency == null) {
            AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)player, "errors.nothing-withdrawable", new TagResolver[0]);
            return;
        }
        this.currency.giveBalance(this.owner, this.earnedMoney);
        AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)player, "money.got", Map.of("%price%", this.currency.getDisplayName().replace("%price%", WarpPlaceholders.format(this.earnedMoney))));
        this.earnedMoney = 0.0;
        AxPlayerWarps.getThreadedQueue().submit(() -> AxPlayerWarps.getDatabase().updateWarp(this));
    }
}

