/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.sorting;

import com.artillexstudios.axplayerwarps.AxPlayerWarps;
import com.artillexstudios.axplayerwarps.enums.Sorting;
import com.artillexstudios.axplayerwarps.libs.axapi.libs.boostedyaml.block.implementation.Section;
import com.artillexstudios.axplayerwarps.sorting.Sort;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class SortingManager {
    private static final LinkedList<Sort> enabledSorting = new LinkedList();

    public static void reload() {
        enabledSorting.clear();
        LinkedList<Sort> sorts = new LinkedList<Sort>();
        Sort def = null;
        for (String raw : AxPlayerWarps.CONFIG.getSection("sorting").getRoutesAsStrings(false)) {
            Section backwards;
            Section section = AxPlayerWarps.CONFIG.getSection("sorting." + raw);
            Section forwards = section.getSection("forwards");
            if (forwards.getBoolean("enabled").booleanValue()) {
                Sort sort = new Sort(forwards.getString("name"), Sorting.valueOf(raw.toUpperCase(Locale.ENGLISH)), false);
                sorts.add(sort);
                if (forwards.getBoolean("default").booleanValue()) {
                    def = sort;
                }
            }
            if (!(backwards = section.getSection("backwards")).getBoolean("enabled").booleanValue()) continue;
            Sort sort = new Sort(backwards.getString("name"), Sorting.valueOf(raw.toUpperCase(Locale.ENGLISH)), true);
            sorts.add(sort);
            if (!backwards.getBoolean("default").booleanValue()) continue;
            def = sort;
        }
        boolean go = false;
        Iterator it = sorts.iterator();
        while (it.hasNext()) {
            Sort sort = (Sort)it.next();
            if (go) {
                enabledSorting.add(sort);
                it.remove();
                continue;
            }
            if (sort != def) continue;
            go = true;
            enabledSorting.add(sort);
            it.remove();
        }
        enabledSorting.addAll(sorts);
    }

    public static List<Sort> getEnabledSorting() {
        return enabledSorting;
    }
}

