/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.libs.gui.utils;

import com.artillexstudios.axplayerwarps.libs.axapi.items.WrappedItemStack;
import com.artillexstudios.axplayerwarps.libs.axapi.items.component.DataComponents;
import com.artillexstudios.axplayerwarps.libs.axapi.items.component.type.ItemLore;
import com.artillexstudios.axplayerwarps.libs.axapi.libs.boostedyaml.block.implementation.Section;
import com.artillexstudios.axplayerwarps.libs.axapi.placeholders.PlaceholderHandler;
import com.artillexstudios.axplayerwarps.libs.axapi.placeholders.PlaceholderParameters;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.ItemBuilder;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.NumberUtils;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.StringUtils;
import com.artillexstudios.axplayerwarps.libs.gui.placeholders.PlaceholderHook;
import com.artillexstudios.axplayerwarps.libs.gui.placeholders.PlaceholderManager;
import com.artillexstudios.axplayerwarps.libs.gui.replacements.Replacements;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBuilderUtil {
    @NotNull
    public static ItemBuilder newBuilder(@Nullable Player player, @NotNull Section section) {
        return ItemBuilderUtil.newBuilder(player, section, new Replacements(), null);
    }

    @NotNull
    public static ItemBuilder newBuilder(@Nullable Player player, @NotNull Section section, PlaceholderParameters placeholderParameters) {
        return ItemBuilderUtil.newBuilder(player, section, new Replacements(), placeholderParameters);
    }

    @NotNull
    public static ItemBuilder newBuilder(@Nullable Player player, @NotNull Section section, Replacements replacements, PlaceholderParameters placeholderParameters) {
        Map<Object, Object> mapped = ItemBuilderUtil.mapSection(section);
        PlaceholderHook placeholderHook = PlaceholderManager.getPlaceholderHook();
        section.getOptionalString("material").ifPresent(material -> {
            material = replacements.apply((String)material);
            material = placeholderHook.setPlaceholders((OfflinePlayer)player, (String)material);
            material = PlaceholderHandler.parse(material, placeholderParameters);
            mapped.put("material", material);
        });
        mapped.remove("name");
        mapped.remove("lore");
        mapped.remove("amount");
        ItemBuilder builder = ItemBuilder.create(mapped, TagResolver.resolver(new TagResolver[0]));
        WrappedItemStack wrapped = builder.wrapped();
        section.getOptionalString("name").ifPresent(name -> {
            name = replacements.apply((String)name);
            name = placeholderHook.setPlaceholders((OfflinePlayer)player, (String)name);
            name = PlaceholderHandler.parse(name, placeholderParameters);
            wrapped.set(DataComponents.customName(), StringUtils.format(name, new TagResolver[0]));
        });
        section.getOptionalStringList("lore").ifPresent(lore -> {
            lore = replacements.apply((List<String>)lore);
            lore = placeholderHook.setPlaceholders((OfflinePlayer)player, (List<String>)lore);
            lore.replaceAll(s -> PlaceholderHandler.parse(s, placeholderParameters));
            lore = ItemBuilderUtil.parseLore(lore);
            wrapped.set(DataComponents.lore(), new ItemLore(StringUtils.formatList(lore, new TagResolver[0])));
        });
        section.getOptionalString("amount").ifPresent(amount -> {
            amount = replacements.apply((String)amount);
            amount = placeholderHook.setPlaceholders((OfflinePlayer)player, (String)amount);
            if (!NumberUtils.isInt(amount = PlaceholderHandler.parse(amount, placeholderParameters))) {
                amount = "1";
            }
            wrapped.setAmount(Math.clamp((long)Integer.parseInt(amount), 1, 64));
        });
        wrapped.finishEdit();
        return builder;
    }

    @NotNull
    @Contract(value="_ -> new")
    public static ItemBuilder newBuilder(@NotNull ItemStack itemStack) {
        return ItemBuilder.create(itemStack);
    }

    private static Map<Object, Object> mapSection(Section section) {
        Set<Object> keys = section.getKeys();
        HashMap<Object, Object> map = new HashMap<Object, Object>(keys.size());
        for (Object key : keys) {
            map.put(key.toString(), section.get(key.toString()));
        }
        return map;
    }

    private static List<String> parseLore(List<String> lore) {
        ArrayList<String> finalLore = new ArrayList<String>();
        for (String line : lore) {
            if (line.contains("<br>")) {
                String[] st = line.split("<br>");
                finalLore.addAll(Arrays.asList(st));
                continue;
            }
            finalLore.add(line);
        }
        return finalLore;
    }
}

