/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.libs.axintegrations.integration.protection.implementation;

import com.artillexstudios.axplayerwarps.libs.axintegrations.AxIntegrations;
import com.artillexstudios.axplayerwarps.libs.axintegrations.integration.protection.ProtectionIntegration;
import com.artillexstudios.axplayerwarps.libs.axintegrations.plugin.RequiredPlugin;
import me.angeschossen.lands.api.LandsIntegration;
import me.angeschossen.lands.api.flags.type.Flags;
import me.angeschossen.lands.api.land.LandWorld;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class LandsProtectionIntegration
implements ProtectionIntegration {
    private final LandsIntegration instance = LandsIntegration.of((Plugin)JavaPlugin.getProvidingPlugin(AxIntegrations.class));

    @Override
    public boolean canBuild(Player player, Location location) {
        LandWorld world = this.instance.getWorld(location.getWorld());
        if (world == null) {
            return true;
        }
        return world.hasRoleFlag(player.getUniqueId(), location, Flags.BLOCK_PLACE);
    }

    @Override
    public boolean canPlace(Player player, Location location) {
        LandWorld world = this.instance.getWorld(location.getWorld());
        if (world == null) {
            return true;
        }
        return world.hasRoleFlag(player.getUniqueId(), location, Flags.BLOCK_PLACE);
    }

    @Override
    public boolean canBreak(Player player, Location location) {
        LandWorld world = this.instance.getWorld(location.getWorld());
        if (world == null) {
            return true;
        }
        return world.hasRoleFlag(player.getUniqueId(), location, Flags.BLOCK_BREAK);
    }

    @Override
    public boolean canInteract(Player player, Location location) {
        LandWorld world = this.instance.getWorld(location.getWorld());
        if (world == null) {
            return true;
        }
        return world.hasRoleFlag(player.getUniqueId(), location, Flags.INTERACT_GENERAL);
    }

    @Override
    public boolean canOpen(Player player, Location location) {
        LandWorld world = this.instance.getWorld(location.getWorld());
        if (world == null) {
            return true;
        }
        return world.hasRoleFlag(player.getUniqueId(), location, Flags.INTERACT_CONTAINER);
    }

    @Override
    public RequiredPlugin[] requiredPlugins() {
        return new RequiredPlugin[]{RequiredPlugin.of("Lands")};
    }

    @Override
    public String id() {
        return "lands";
    }
}

