/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.libs.axapi.database.impl;

import com.artillexstudios.axplayerwarps.libs.axapi.AxPlugin;
import com.artillexstudios.axplayerwarps.libs.axapi.database.DatabaseConfig;
import com.artillexstudios.axplayerwarps.libs.axapi.database.DatabaseType;
import com.artillexstudios.axplayerwarps.libs.axapi.libs.hikari.HikariConfig;

public class H2DatabaseType
extends DatabaseType {
    private final String relocated;

    public H2DatabaseType() {
        this("org.h2");
    }

    public H2DatabaseType(String relocated) {
        this.relocated = relocated;
    }

    @Override
    public HikariConfig config(DatabaseConfig databaseConfig) {
        HikariConfig config = new HikariConfig();
        config.setDataSourceClassName(this.relocated + ".jdbcx.JdbcDataSource");
        config.addDataSourceProperty("url", "jdbc:h2:./" + String.valueOf(((AxPlugin)AxPlugin.getPlugin(AxPlugin.class)).getDataFolder()) + "/data");
        config.setMaximumPoolSize(databaseConfig.pool.maximumPoolSize);
        config.setMinimumIdle(databaseConfig.pool.minimumIdle);
        return config;
    }

    @Override
    public String name() {
        return "h2";
    }
}

