/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.hooks.currency;

import com.artillexstudios.axplayerwarps.hooks.currency.CurrencyHook;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.StringUtils;
import java.util.Optional;
import java.util.UUID;
import me.TechsCode.UltraEconomy.UltraEconomy;
import me.TechsCode.UltraEconomy.objects.Account;
import me.TechsCode.UltraEconomy.objects.Currency;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

public class UltraEconomyHook
implements CurrencyHook {
    private Currency currency = null;
    private final String internal;
    private final String name;

    public UltraEconomyHook(String internal, String name) {
        this.internal = internal;
        this.name = name;
    }

    @Override
    public void setup() {
        Optional currencyOptional = UltraEconomy.getAPI().getCurrencies().name(this.internal);
        if (currencyOptional.isEmpty()) {
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF0000[AxPlayerWarps] UltraEconomy currency named &#DD0000" + this.internal + " &#FF0000not found! Change the currency-name or disable the hook to get rid of this warning!", new TagResolver[0]));
            return;
        }
        this.currency = (Currency)currencyOptional.get();
    }

    @Override
    public String getName() {
        return "UltraEconomy-" + this.internal;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public boolean worksOffline() {
        return true;
    }

    @Override
    public boolean usesDouble() {
        return true;
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public double getBalance(@NotNull UUID player) {
        if (this.currency == null) {
            return 0.0;
        }
        Optional account = UltraEconomy.getAPI().getAccounts().uuid(player);
        return account.map(value -> value.getBalance(this.currency).getOnHand()).orElse(0.0);
    }

    @Override
    public void giveBalance(@NotNull UUID player, double amount) {
        if (this.currency == null) {
            return;
        }
        Optional account = UltraEconomy.getAPI().getAccounts().uuid(player);
        if (account.isEmpty()) {
            return;
        }
        ((Account)account.get()).addBalance(this.currency, amount);
    }

    @Override
    public void takeBalance(@NotNull UUID player, double amount) {
        if (this.currency == null) {
            return;
        }
        Optional account = UltraEconomy.getAPI().getAccounts().uuid(player);
        if (account.isEmpty()) {
            return;
        }
        ((Account)account.get()).removeBalance(this.currency, amount);
    }
}

