/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.category;

import com.artillexstudios.axplayerwarps.AxPlayerWarps;
import com.artillexstudios.axplayerwarps.category.Category;
import com.artillexstudios.axplayerwarps.libs.axapi.libs.boostedyaml.block.implementation.Section;
import com.artillexstudios.axplayerwarps.warps.Warp;
import com.artillexstudios.axplayerwarps.warps.WarpManager;
import java.util.LinkedHashMap;

public class CategoryManager {
    private static final LinkedHashMap<String, Category> categories = new LinkedHashMap();

    public static void reload() {
        categories.clear();
        AxPlayerWarps.getThreadedQueue().submit(() -> {
            if (AxPlayerWarps.CONFIG.getSection("categories") == null) {
                return;
            }
            for (String raw : AxPlayerWarps.CONFIG.getSection("categories").getRoutesAsStrings(false)) {
                Section section = AxPlayerWarps.CONFIG.getSection("categories." + raw);
                String name = section.getString("name");
                int id = AxPlayerWarps.getDatabase().getCategoryId(raw);
                Category category = new Category(id, raw, name, section);
                categories.put(raw, category);
            }
            for (Warp warp : WarpManager.getWarps()) {
                Category curr = warp.getCategory();
                if (curr == null) continue;
                Category nw = categories.get(curr.raw());
                warp.setCategory(nw);
            }
        });
    }

    public static LinkedHashMap<String, Category> getCategories() {
        return categories;
    }
}

