/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.user;

import com.artillexstudios.axplayerwarps.AxPlayerWarps;
import com.artillexstudios.axplayerwarps.category.Category;
import com.artillexstudios.axplayerwarps.category.CategoryManager;
import com.artillexstudios.axplayerwarps.libs.gui.GuiFrame;
import com.artillexstudios.axplayerwarps.sorting.Sort;
import com.artillexstudios.axplayerwarps.sorting.SortingManager;
import com.artillexstudios.axplayerwarps.warps.Warp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;

public class WarpUser {
    private final Player player;
    private int sortingIdx = 0;
    private int categoryIdx = -1;
    private final CircularFifoQueue<GuiFrame> lastGuis = new CircularFifoQueue(5);
    private List<Warp> favorites = Collections.synchronizedList(new ArrayList());

    public WarpUser(Player player) {
        this.player = player;
        AxPlayerWarps.getThreadedQueue().submit(() -> {
            AxPlayerWarps.getDatabase().loadOrUpdate(player);
            this.favorites = Collections.synchronizedList(AxPlayerWarps.getDatabase().getFavoriteWarps(player));
        });
    }

    public Player getPlayer() {
        return this.player;
    }

    public void resetSorting() {
        this.sortingIdx = 0;
    }

    public void changeSorting(int am) {
        this.sortingIdx += am;
    }

    public Sort getSorting() {
        int a = this.sortingIdx;
        int b = SortingManager.getEnabledSorting().size();
        return SortingManager.getEnabledSorting().get((a % b + b) % b);
    }

    public void resetCategory() {
        this.categoryIdx = -1;
    }

    public void changeCategory(int am) {
        this.categoryIdx += am;
    }

    public Category getCategory() {
        int a = this.categoryIdx;
        int b = CategoryManager.getCategories().size();
        return CategoryManager.getCategories().values().stream().toList().get((a % b + b) % b);
    }

    public CircularFifoQueue<GuiFrame> getLastGuis() {
        return this.lastGuis;
    }

    public void addGui(GuiFrame guiFrame) {
        this.lastGuis.add((Object)guiFrame);
    }

    public List<Warp> getFavorites() {
        return this.favorites;
    }

    public int getWarpLimit() {
        if (WarpUser.hasBypass((OfflinePlayer)this.player)) {
            return Integer.MAX_VALUE;
        }
        int am = this.player.hasPermission("axplayerwarps.warps.1") ? 1 : 0;
        for (PermissionAttachmentInfo effectivePermission : this.player.getEffectivePermissions()) {
            int value;
            if (!effectivePermission.getValue() || !effectivePermission.getPermission().startsWith("axplayerwarps.warps.") || (value = Integer.parseInt(effectivePermission.getPermission().substring(effectivePermission.getPermission().lastIndexOf(46) + 1))) <= am) continue;
            am = value;
        }
        return am;
    }

    public static boolean hasBypass(OfflinePlayer offlinePlayer) {
        if (offlinePlayer.isOp()) {
            return true;
        }
        Player player = offlinePlayer.getPlayer();
        if (player == null) {
            return false;
        }
        if (player.hasPermission("*")) {
            return true;
        }
        return player.hasPermission("axplayerwarps.warps.*");
    }
}

