/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.libs.gui.replacements;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class Replacements {
    private final Map<String, Object> replacements = new HashMap<String, Object>();

    public Replacements() {
    }

    public Replacements(Object key, Supplier<String> value) {
        this.and(key, value);
    }

    public Replacements(Object key, Object value) {
        this.and(key, value);
    }

    public Replacements and(Object key, Supplier<String> value) {
        this.replacements.put(key.toString(), value);
        return this;
    }

    public Replacements and(Object key, Object value) {
        this.replacements.put(key.toString(), value);
        return this;
    }

    public Replacements and(Replacements another) {
        this.replacements.putAll(another.get());
        return this;
    }

    public Map<String, Object> get() {
        return this.replacements;
    }

    public String apply(String original) {
        for (Map.Entry<String, Object> entry : this.replacements.entrySet()) {
            Object object = entry.getValue();
            if (object instanceof Supplier) {
                Supplier supplier = (Supplier)object;
                original = original.replace(entry.getKey(), (CharSequence)supplier.get());
                continue;
            }
            original = original.replace(entry.getKey(), entry.getValue().toString());
        }
        return original;
    }

    public List<String> apply(List<String> originals) {
        ArrayList<String> list = new ArrayList<String>();
        for (String original : originals) {
            list.add(this.apply(original));
        }
        return list;
    }

    public List<String> apply(String ... originals) {
        ArrayList<String> list = new ArrayList<String>();
        for (String original : originals) {
            list.add(this.apply(original));
        }
        return list;
    }
}

