/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.libs.gui;

import com.artillexstudios.axplayerwarps.libs.axapi.config.Config;
import com.artillexstudios.axplayerwarps.libs.axapi.libs.boostedyaml.block.implementation.Section;
import com.artillexstudios.axplayerwarps.libs.axapi.placeholders.PlaceholderHandler;
import com.artillexstudios.axplayerwarps.libs.axapi.placeholders.PlaceholderParameters;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.NumberUtils;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.StringUtils;
import com.artillexstudios.axplayerwarps.libs.gui.GuiUpdater;
import com.artillexstudios.axplayerwarps.libs.gui.actions.GuiActions;
import com.artillexstudios.axplayerwarps.libs.gui.item.AxGuiItem;
import com.artillexstudios.axplayerwarps.libs.gui.replacements.Replacements;
import com.artillexstudios.axplayerwarps.libs.gui.utils.ItemBuilderUtil;
import com.artillexstudios.gui.guis.BaseGui;
import com.artillexstudios.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GuiFrame {
    public static final Set<GuiFrame> openedGuis = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    protected Config file;
    protected BaseGui gui;
    protected Player player;
    protected int updateTicks;
    private final Replacements globalReplacements = new Replacements();
    private PlaceholderParameters placeholderParameters = new PlaceholderParameters();

    public GuiFrame() {
    }

    public GuiFrame(int updateTicks, Config file, Player player) {
        this.updateTicks = updateTicks;
        if (this.updateTicks > 0) {
            GuiUpdater.start();
        }
        this.file = file;
        this.player = player;
        this.placeholderParameters.withParameter(player);
    }

    public int getUpdateTicks() {
        return this.updateTicks;
    }

    public void setUpdateTicks(int updateTicks) {
        this.updateTicks = updateTicks;
    }

    public PlaceholderParameters getPlaceholderParameters() {
        return this.placeholderParameters;
    }

    public void addPlaceholderParameter(Object ... object) {
        this.placeholderParameters = this.placeholderParameters.withParameters(object);
    }

    public Replacements getReplacements() {
        return this.globalReplacements;
    }

    public void addReplacement(Replacements replacements) {
        this.globalReplacements.and(replacements);
    }

    public String parseText(String original) {
        original = this.globalReplacements.apply(original);
        original = PlaceholderHandler.parse(original, this.placeholderParameters);
        return original;
    }

    public List<String> parseText(List<String> originals) {
        ArrayList<String> parsedList = new ArrayList<String>();
        for (String original : originals) {
            parsedList.add(this.parseText(original));
        }
        return parsedList;
    }

    public String[] parseText(String ... originals) {
        String[] parsedArray = new String[originals.length];
        for (int i = 0; i < originals.length; ++i) {
            parsedArray[i] = this.parseText(originals[i]);
        }
        return parsedArray;
    }

    public String parseText(String original, Object ... object) {
        original = this.globalReplacements.apply(original);
        original = PlaceholderHandler.parse(original, this.placeholderParameters.copy().withParameters(object));
        return original;
    }

    public List<String> parseText(List<String> originals, Object ... object) {
        ArrayList<String> parsedList = new ArrayList<String>();
        for (String original : originals) {
            parsedList.add(this.parseText(original, object));
        }
        return parsedList;
    }

    @NotNull
    public Config getFile() {
        return this.file;
    }

    public BaseGui getGui() {
        return this.gui;
    }

    public void setGui(BaseGui gui) {
        gui.setOpenGuiAction(open -> openedGuis.add(this));
        gui.setCloseGuiAction(event -> openedGuis.remove(this));
        this.gui = gui;
        this.updateStaticItems();
    }

    public void updateStaticItems() {
        for (String str : this.file.getBackingDocument().getRoutesAsStrings(false)) {
            this.createItem(str);
        }
    }

    public List<Integer> getSlots(List<String> s) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (String str : s) {
            int i;
            int i2;
            int max;
            int min;
            if (NumberUtils.isInt(str)) {
                slots.add(Integer.parseInt(str));
                continue;
            }
            if (str.contains("-")) {
                String[] split = str.split("-");
                min = Integer.parseInt(split[0]);
                max = Integer.parseInt(split[1]);
                for (i2 = min; i2 <= max; ++i2) {
                    slots.add(i2);
                }
                continue;
            }
            if (str.contains("|")) {
                String[] split = str.split("\\|");
                min = Integer.parseInt(split[0]);
                max = Integer.parseInt(split[1]);
                for (i2 = min; i2 <= max; i2 += 9) {
                    slots.add(i2);
                }
                continue;
            }
            if (!str.equals("border")) continue;
            int rows = this.gui.getRows();
            for (i = 0; i < 9; ++i) {
                slots.add(i);
            }
            for (i = 9 * (rows - 1); i < 9 * rows; ++i) {
                slots.add(i);
            }
            for (i = 0; i < rows * 9; i += 9) {
                slots.add(i);
            }
            for (i = 8; i < rows * 9 + 8; i += 9) {
                slots.add(i);
            }
        }
        return slots;
    }

    protected ItemStack buildItem(@NotNull String key) {
        return this.buildItem(key, new Replacements());
    }

    protected ItemStack buildItem(@NotNull String key, Replacements replacements) {
        ItemMeta itemMeta;
        Section section = this.file.getSection(key);
        ItemStack item = ItemBuilderUtil.newBuilder(this.player, section, this.globalReplacements.and(replacements), this.placeholderParameters).get();
        if (section.getOptionalString("texture").isEmpty() && (itemMeta = item.getItemMeta()) instanceof SkullMeta) {
            SkullMeta skullMeta = (SkullMeta)itemMeta;
            skullMeta.setOwningPlayer((OfflinePlayer)this.player);
            item.setItemMeta((ItemMeta)skullMeta);
        }
        return item;
    }

    protected AxGuiItem createItem(@NotNull String route) {
        return this.createItem(route, (Consumer<InventoryClickEvent>)null);
    }

    protected AxGuiItem createItem(@NotNull String route, @Nullable Consumer<InventoryClickEvent> action) {
        return this.createItem(route, action, new Replacements());
    }

    protected AxGuiItem createItem(@NotNull String route, @Nullable Consumer<InventoryClickEvent> action, Replacements replacements) {
        return this.createItem(route, null, action, replacements, List.of());
    }

    protected AxGuiItem createItem(@NotNull String route, @Nullable Consumer<InventoryClickEvent> action, List<Integer> overrideSlots) {
        return this.createItem(route, action, new Replacements(), overrideSlots);
    }

    protected AxGuiItem createItem(@NotNull String route, @Nullable Consumer<InventoryClickEvent> action, Replacements replacements, List<Integer> overrideSlots) {
        return this.createItem(route, null, action, replacements, overrideSlots);
    }

    protected AxGuiItem createItem(@NotNull String route, Replacements replacements) {
        return this.createItem(route, null, null, replacements, List.of());
    }

    protected AxGuiItem createItem(@NotNull String route, ItemStack item) {
        return this.createItem(route, item, null, new Replacements(), List.of());
    }

    protected AxGuiItem createItem(@NotNull String route, @Nullable ItemStack item, @Nullable Consumer<InventoryClickEvent> action, Replacements replacements, List<Integer> overrideSlots) {
        Section section = this.file.getSection(route);
        if (section == null) {
            return null;
        }
        if (section.getString("material", null) == null && section.getString("type", null) == null) {
            return null;
        }
        AxGuiItem guiItem = new AxGuiItem(item == null ? this.buildItem(route, replacements) : item, event -> {
            GuiActions.run(this.player, this, event, this.file.getStringList(route + ".actions"));
            if (action == null) {
                return;
            }
            action.accept((InventoryClickEvent)event);
        });
        if (overrideSlots.isEmpty()) {
            List<String> slots = this.file.getBackingDocument().getStringList(route + ".slot");
            String slot = this.file.getString(route + ".slot");
            if (slot == null) {
                return null;
            }
            List<Integer> finalSlots = this.getSlots(slots.isEmpty() ? List.of(slot) : slots);
            this.gui.setItem(finalSlots, (GuiItem)guiItem);
        } else {
            this.gui.setItem(overrideSlots, (GuiItem)guiItem);
        }
        return guiItem;
    }

    public void extendLore(ItemStack item, String ... lore) {
        ItemMeta meta = item.getItemMeta();
        ArrayList<String> newLore = new ArrayList<String>();
        if (meta.getLore() != null) {
            newLore.addAll(meta.getLore());
        }
        newLore.addAll(StringUtils.formatListToString(Arrays.asList(lore), new TagResolver[0]));
        meta.setLore(newLore);
        item.setItemMeta(meta);
    }

    public void updateTitle() {
    }

    public void open(int page) {
        this.open();
    }

    public void open() {
    }

    public void update() {
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GuiFrame guiFrame = (GuiFrame)o;
        return Objects.equals(this.file, guiFrame.file) && Objects.equals(this.gui, guiFrame.gui) && Objects.equals(this.player, guiFrame.player);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.file);
        result = 31 * result + Objects.hashCode(this.gui);
        result = 31 * result + Objects.hashCode(this.player);
        return result;
    }
}

