/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.hooks.currency;

import com.artillexstudios.axplayerwarps.AxPlayerWarps;
import com.artillexstudios.axplayerwarps.hooks.currency.CurrencyHook;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.jetbrains.annotations.NotNull;

public class VaultHook
implements CurrencyHook {
    private Economy econ = null;

    @Override
    public void setup() {
        RegisteredServiceProvider rsp = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return;
        }
        this.econ = (Economy)rsp.getProvider();
    }

    @Override
    public String getName() {
        return "Vault";
    }

    @Override
    public String getDisplayName() {
        return AxPlayerWarps.CURRENCIES.getString("currencies.Vault.name");
    }

    @Override
    public boolean worksOffline() {
        return true;
    }

    @Override
    public boolean usesDouble() {
        return true;
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public double getBalance(@NotNull UUID player) {
        return this.econ.getBalance(Bukkit.getOfflinePlayer((UUID)player));
    }

    @Override
    public void giveBalance(@NotNull UUID player, double amount) {
        this.econ.depositPlayer(Bukkit.getOfflinePlayer((UUID)player), amount);
    }

    @Override
    public void takeBalance(@NotNull UUID player, double amount) {
        this.econ.withdrawPlayer(Bukkit.getOfflinePlayer((UUID)player), amount);
    }
}

