/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.hooks.currency;

import com.artillexstudios.axplayerwarps.AxPlayerWarps;
import com.artillexstudios.axplayerwarps.hooks.currency.CurrencyHook;
import java.util.UUID;
import org.black_ixx.playerpoints.PlayerPoints;
import org.black_ixx.playerpoints.PlayerPointsAPI;
import org.jetbrains.annotations.NotNull;

public class PlayerPointsHook
implements CurrencyHook {
    private PlayerPointsAPI econ = null;

    @Override
    public void setup() {
        this.econ = PlayerPoints.getInstance().getAPI();
    }

    @Override
    public String getName() {
        return "PlayerPoints";
    }

    @Override
    public String getDisplayName() {
        return AxPlayerWarps.CURRENCIES.getString("currencies.PlayerPoints.name");
    }

    @Override
    public boolean worksOffline() {
        return true;
    }

    @Override
    public boolean usesDouble() {
        return false;
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public double getBalance(@NotNull UUID player) {
        return this.econ.look(player);
    }

    @Override
    public void giveBalance(@NotNull UUID player, double amount) {
        this.econ.give(player, (int)amount);
    }

    @Override
    public void takeBalance(@NotNull UUID player, double amount) {
        this.econ.take(player, (int)Math.round(amount));
    }
}

