/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.guis;

import com.artillexstudios.axplayerwarps.AxPlayerWarps;
import com.artillexstudios.axplayerwarps.category.Category;
import com.artillexstudios.axplayerwarps.guis.EditWarpGui;
import com.artillexstudios.axplayerwarps.input.InputManager;
import com.artillexstudios.axplayerwarps.libs.axapi.config.Config;
import com.artillexstudios.axplayerwarps.libs.axapi.libs.boostedyaml.settings.dumper.DumperSettings;
import com.artillexstudios.axplayerwarps.libs.axapi.libs.boostedyaml.settings.general.GeneralSettings;
import com.artillexstudios.axplayerwarps.libs.axapi.libs.boostedyaml.settings.loader.LoaderSettings;
import com.artillexstudios.axplayerwarps.libs.axapi.libs.boostedyaml.settings.updater.UpdaterSettings;
import com.artillexstudios.axplayerwarps.libs.axapi.nms.wrapper.ServerPlayerWrapper;
import com.artillexstudios.axplayerwarps.libs.axapi.scheduler.Scheduler;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.AsyncUtils;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.ItemBuilder;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.PlayerTextures;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.StringUtils;
import com.artillexstudios.axplayerwarps.libs.gui.GuiFrame;
import com.artillexstudios.axplayerwarps.libs.gui.actions.GuiActions;
import com.artillexstudios.axplayerwarps.libs.gui.item.AxGuiItem;
import com.artillexstudios.axplayerwarps.libs.gui.replacements.Replacements;
import com.artillexstudios.axplayerwarps.sorting.WarpComparator;
import com.artillexstudios.axplayerwarps.user.Users;
import com.artillexstudios.axplayerwarps.user.WarpUser;
import com.artillexstudios.axplayerwarps.warps.Warp;
import com.artillexstudios.axplayerwarps.warps.WarpManager;
import com.artillexstudios.gui.builder.gui.PaginatedBuilder;
import com.artillexstudios.gui.guis.Gui;
import com.artillexstudios.gui.guis.GuiItem;
import com.artillexstudios.gui.guis.PaginatedGui;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class MyWarpsGui
extends GuiFrame {
    private static final Config GUI = new Config(new File(AxPlayerWarps.getInstance().getDataFolder(), "guis/my-warps.yml"), AxPlayerWarps.getInstance().getResource("guis/my-warps.yml"), GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().build(), DumperSettings.DEFAULT, UpdaterSettings.builder().build());
    private final PaginatedGui gui = ((PaginatedBuilder)((PaginatedBuilder)((PaginatedBuilder)Gui.paginated().disableAllInteractions()).title((Component)Component.empty())).rows(GUI.getInt("rows", 5))).pageSize(GUI.getInt("page-size", 27)).create();
    private Category category = null;
    private String search = null;
    private final WarpUser user;

    public MyWarpsGui(Player player, Category category, String search) {
        this(player, category);
        this.search = search;
    }

    public MyWarpsGui(Player player, Category category) {
        this(player);
        this.category = category;
    }

    public MyWarpsGui(Player player) {
        super(GUI.getInt("auto-update-ticks", -1), GUI, player);
        this.user = Users.get(player);
        this.addReplacement(new Replacements((Object)"%search%", () -> this.search == null ? AxPlayerWarps.LANG.getString("placeholders.no-search") : this.search));
        this.addReplacement(new Replacements((Object)"%category_selected%", () -> this.category == null ? AxPlayerWarps.LANG.getString("placeholders.no-category") : this.category.formatted()));
        this.setGui(this.gui);
        this.user.addGui(this);
    }

    public static boolean reload() {
        return GUI.reload();
    }

    @Override
    public void open() {
        this.open(1);
    }

    @Override
    public void open(int page) {
        this.createItem("search", (InventoryClickEvent event) -> {
            GuiActions.run(this.player, this, event, this.file.getStringList("search.actions"));
            if (event.isShiftClick()) {
                this.search = null;
                AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)this.player, "search.reset", new TagResolver[0]);
                this.open();
                return;
            }
            InputManager.getInput(this.player, "search", result -> {
                this.search = result.isBlank() ? null : result;
                if (this.search == null) {
                    AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)this.player, "search.reset", new TagResolver[0]);
                } else {
                    AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)this.player, "search.show", Map.of("%search%", this.search));
                }
                this.open();
            });
        });
        this.createItem("sorting", (InventoryClickEvent event) -> {
            GuiActions.run(this.player, this, event, this.file.getStringList("sorting.actions"));
            if (event.isShiftClick()) {
                this.user.resetSorting();
            } else {
                if (event.isLeftClick()) {
                    this.user.changeSorting(1);
                }
                if (event.isRightClick()) {
                    this.user.changeSorting(-1);
                }
            }
            this.open(this.gui.getCurrentPageNum());
        });
        this.createItem("category", (InventoryClickEvent event) -> {
            GuiActions.run(this.player, this, event, this.file.getStringList("category.actions"));
            if (event.isShiftClick()) {
                this.user.resetCategory();
                this.category = null;
                this.open(this.gui.getCurrentPageNum());
                return;
            }
            if (event.isLeftClick()) {
                this.user.changeCategory(1);
            }
            if (event.isRightClick()) {
                this.user.changeCategory(-1);
            }
            this.category = this.user.getCategory();
            this.open(this.gui.getCurrentPageNum());
        });
        this.loadWarps().thenRun(() -> this.gui.open((HumanEntity)this.player, page));
    }

    @Override
    public void update() {
        this.loadWarps().thenRun(() -> this.gui.update());
    }

    @Override
    public void updateTitle() {
        this.gui.updateTitle(StringUtils.format(GUI.getString("title", ""), new HashMap<String, CallSite>(Map.of("%page%", "" + this.gui.getCurrentPageNum(), "%pages%", "" + Math.max(1, this.gui.getPagesNum())))));
    }

    public CompletableFuture<Void> loadWarps() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        AsyncUtils.submit(() -> {
            List<Warp> filtered = WarpManager.getWarps().stream().filter(warp -> warp.getOwner().equals(this.player.getUniqueId())).sorted(new WarpComparator(this.user.getSorting(), this.player)).toList();
            AxGuiItem[] axGuiItems = new AxGuiItem[filtered.size()];
            ArrayList futures = new ArrayList();
            int i = 0;
            for (Warp warp2 : filtered) {
                if (this.category != null && !Objects.equals(warp2.getCategory(), this.category) || this.search != null && !warp2.getName().toLowerCase().contains(this.search) && !warp2.getOwnerName().toLowerCase().contains(this.search)) continue;
                CompletableFuture completableFuture = new CompletableFuture();
                futures.add(completableFuture);
                int i2 = i++;
                AsyncUtils.submit(() -> {
                    AxGuiItem axGuiItem;
                    ServerPlayerWrapper wrapper;
                    PlayerTextures textures;
                    Player pl;
                    Material icon = warp2.getIcon();
                    ItemBuilder builder = ItemBuilder.create(new ItemStack(icon));
                    builder.setName(this.parseText(GUI.getString("warp.name"), warp2));
                    String[] description = warp2.getDescription().split("\n", AxPlayerWarps.CONFIG.getInt("warp-description.max-lines", 3));
                    ArrayList<String> lore = new ArrayList<String>();
                    ArrayList<String> lore2 = new ArrayList<String>(GUI.getStringList("warp.lore"));
                    for (int j = 0; j < lore2.size(); ++j) {
                        String line = (String)lore2.get(j);
                        if (!line.contains("%description%")) {
                            lore.add(line);
                            continue;
                        }
                        for (int k = description.length - 1; k >= 0; --k) {
                            lore.add(j, line.replace("%description%", description[k]));
                        }
                    }
                    builder.setLore(this.parseText(lore, warp2));
                    if (icon == Material.PLAYER_HEAD && (pl = Bukkit.getPlayer((UUID)warp2.getOwner())) != null && (textures = (wrapper = ServerPlayerWrapper.wrap(pl)).textures()).texture() != null) {
                        builder.setTextureValue(textures.texture());
                    }
                    axGuiItems[i2] = axGuiItem = new AxGuiItem(builder.get(), event -> {
                        if (event.isLeftClick()) {
                            warp2.teleportPlayer(this.player);
                        } else {
                            if (!this.player.hasPermission("axplayerwarps.edit")) {
                                AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)this.player, "errors.no-permission", new TagResolver[0]);
                                return;
                            }
                            new EditWarpGui(this.player, warp2).open();
                        }
                    });
                    completableFuture.complete(null);
                });
            }
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenRun(() -> {
                this.gui.clearPageItems();
                for (AxGuiItem axGuiItem : axGuiItems) {
                    if (axGuiItem == null) continue;
                    this.gui.addItem((GuiItem)axGuiItem);
                }
                Scheduler.get().run(scheduledTask -> {
                    this.updateTitle();
                    future.complete(null);
                });
            });
        });
        return future;
    }
}

