/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.placeholders;

import com.artillexstudios.axplayerwarps.AxPlayerWarps;
import com.artillexstudios.axplayerwarps.database.impl.Base;
import com.artillexstudios.axplayerwarps.enums.AccessList;
import com.artillexstudios.axplayerwarps.libs.axapi.placeholders.PlaceholderArgument;
import com.artillexstudios.axplayerwarps.libs.axapi.placeholders.PlaceholderArguments;
import com.artillexstudios.axplayerwarps.libs.axapi.placeholders.PlaceholderContext;
import com.artillexstudios.axplayerwarps.libs.axapi.placeholders.PlaceholderHandler;
import com.artillexstudios.axplayerwarps.libs.axapi.placeholders.exception.PlaceholderException;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.functions.ThrowingFunction;
import com.artillexstudios.axplayerwarps.placeholders.resolvers.WarpResolver;
import com.artillexstudios.axplayerwarps.user.Users;
import com.artillexstudios.axplayerwarps.user.WarpUser;
import com.artillexstudios.axplayerwarps.utils.FormatUtils;
import com.artillexstudios.axplayerwarps.utils.StarUtils;
import com.artillexstudios.axplayerwarps.utils.TimeUtils;
import com.artillexstudios.axplayerwarps.warps.Warp;
import com.artillexstudios.axplayerwarps.warps.WarpManager;
import java.text.DecimalFormat;
import java.util.Optional;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class WarpPlaceholders {
    private static final PlaceholderArgument<Warp> warpArg = new PlaceholderArgument("warp", WarpResolver.class);
    public static final DecimalFormat df = new DecimalFormat("#.##");
    private static String noCategory;

    public static String format(Object obj) {
        return df.format(obj);
    }

    public static void reload() {
        noCategory = AxPlayerWarps.LANG.getString("placeholders.no-category");
    }

    public static void load() {
        WarpPlaceholders.reload();
        String empty = "";
        ThrowingFunction<PlaceholderContext, String, PlaceholderException> totalHandler = handler -> String.valueOf(WarpManager.getWarps().size());
        PlaceholderHandler.register("total_warps", totalHandler, true);
        PlaceholderHandler.register("all_warps", totalHandler, true);
        PlaceholderHandler.register("player_warp_limit", handler -> {
            Player player = handler.raw(Player.class);
            if (player == null) {
                return empty;
            }
            WarpUser user = Users.get(player);
            return String.valueOf(user.getWarpLimit());
        }, true);
        ThrowingFunction<PlaceholderContext, String, PlaceholderException> playerWarpsHandler = handler -> {
            Player player = handler.raw(Player.class);
            if (player == null) {
                return empty;
            }
            return String.valueOf(WarpManager.getWarps().stream().filter(warp -> warp.getOwner().equals(player.getUniqueId())).count());
        };
        PlaceholderHandler.register("player_warps", playerWarpsHandler, true);
        PlaceholderHandler.register("my_warps", playerWarpsHandler, true);
        PlaceholderHandler.register("favorite_warps", handler -> {
            Player player = handler.raw(Player.class);
            if (player == null) {
                return empty;
            }
            WarpUser user = Users.get(player);
            return String.valueOf(user.getFavorites().size());
        }, true);
        PlaceholderHandler.register("sorting_selected", handler -> {
            Player player = handler.raw(Player.class);
            if (player == null) {
                return empty;
            }
            WarpUser user = Users.get(player);
            return user.getSorting().name();
        }, true);
        PlaceholderHandler.register("player", handler -> {
            Base.AccessPlayer accessPlayer = handler.raw(Base.AccessPlayer.class);
            if (accessPlayer == null) {
                return empty;
            }
            return accessPlayer.name();
        }, false);
        PlaceholderHandler.register("added-date", handler -> {
            Base.AccessPlayer accessPlayer = handler.raw(Base.AccessPlayer.class);
            if (accessPlayer == null) {
                return empty;
            }
            return TimeUtils.formatDate(accessPlayer.added());
        }, false);
        WarpPlaceholders.registerWarp("id", handler -> {
            Warp warp = WarpPlaceholders.getWarp(handler);
            if (warp == null) {
                return empty;
            }
            return String.valueOf(warp.getId());
        });
        WarpPlaceholders.registerWarp("name", handler -> {
            Warp warp = WarpPlaceholders.getWarp(handler);
            if (warp == null) {
                return empty;
            }
            return warp.getName();
        });
        WarpPlaceholders.registerWarp("owner", handler -> {
            Warp warp = WarpPlaceholders.getWarp(handler);
            if (warp == null) {
                return empty;
            }
            return AxPlayerWarps.getDatabase().getPlayerName(warp.getOwner());
        });
        WarpPlaceholders.registerWarp("created", handler -> {
            Warp warp = WarpPlaceholders.getWarp(handler);
            if (warp == null) {
                return empty;
            }
            return TimeUtils.formatDate(warp.getCreated());
        });
        WarpPlaceholders.registerWarp("world", handler -> {
            Warp warp = WarpPlaceholders.getWarp(handler);
            if (warp == null) {
                return empty;
            }
            World world = warp.getLocation().getWorld();
            if (world == null) {
                return empty;
            }
            return Optional.of(world.getName()).orElse("---");
        });
        WarpPlaceholders.registerWarp("x", handler -> {
            Warp warp = WarpPlaceholders.getWarp(handler);
            if (warp == null) {
                return empty;
            }
            return WarpPlaceholders.format(warp.getLocation().getX());
        });
        WarpPlaceholders.registerWarp("y", handler -> {
            Warp warp = WarpPlaceholders.getWarp(handler);
            if (warp == null) {
                return empty;
            }
            return WarpPlaceholders.format(warp.getLocation().getY());
        });
        WarpPlaceholders.registerWarp("z", handler -> {
            Warp warp = WarpPlaceholders.getWarp(handler);
            if (warp == null) {
                return empty;
            }
            return WarpPlaceholders.format(warp.getLocation().getZ());
        });
        WarpPlaceholders.registerWarp("yaw", handler -> {
            Warp warp = WarpPlaceholders.getWarp(handler);
            if (warp == null) {
                return empty;
            }
            return WarpPlaceholders.format(Float.valueOf(warp.getLocation().getYaw()));
        });
        WarpPlaceholders.registerWarp("pitch", handler -> {
            Warp warp = WarpPlaceholders.getWarp(handler);
            if (warp == null) {
                return empty;
            }
            return WarpPlaceholders.format(Float.valueOf(warp.getLocation().getPitch()));
        });
        WarpPlaceholders.registerWarp("category", handler -> {
            Warp warp = WarpPlaceholders.getWarp(handler);
            if (warp == null) {
                return empty;
            }
            if (warp.getCategory() == null) {
                return noCategory;
            }
            return AxPlayerWarps.CONFIG.getString("categories." + warp.getCategory().raw() + ".name", warp.getCategory().raw());
        });
        WarpPlaceholders.registerWarp("price", handler -> {
            Warp warp = WarpPlaceholders.getWarp(handler);
            if (warp == null) {
                return empty;
            }
            double price = warp.getCurrency() == null ? 0.0 : warp.getTeleportPrice();
            boolean isFree = warp.getCurrency() == null || warp.getTeleportPrice() == 0.0;
            return isFree ? AxPlayerWarps.LANG.getString("placeholders.free") : warp.getCurrency().getDisplayName().replace("%price%", WarpPlaceholders.format(price));
        });
        WarpPlaceholders.registerWarp("price-full", handler -> {
            Warp warp = WarpPlaceholders.getWarp(handler);
            if (warp == null) {
                return empty;
            }
            return FormatUtils.formatCurrency(warp.getCurrency(), warp.getTeleportPrice());
        });
        WarpPlaceholders.registerWarp("access", handler -> {
            Warp warp = WarpPlaceholders.getWarp(handler);
            if (warp == null) {
                return empty;
            }
            return AxPlayerWarps.LANG.getString("access." + warp.getAccess().name().toLowerCase());
        });
        WarpPlaceholders.registerWarp("earned_money", handler -> {
            Warp warp = WarpPlaceholders.getWarp(handler);
            if (warp == null) {
                return empty;
            }
            double earned = warp.getEarnedMoney();
            return FormatUtils.formatCurrency(warp.getCurrency(), earned);
        });
        WarpPlaceholders.registerWarp("rating_decimal", handler -> {
            Warp warp = WarpPlaceholders.getWarp(handler);
            if (warp == null) {
                return empty;
            }
            float rating = warp.getRating();
            return WarpPlaceholders.format(Float.valueOf(rating));
        });
        WarpPlaceholders.registerWarp("rating_stars", handler -> {
            Warp warp = WarpPlaceholders.getWarp(handler);
            if (warp == null) {
                return empty;
            }
            float rating = warp.getRating();
            int starAm = Math.round(rating);
            return StarUtils.getFormatted(starAm, 5);
        });
        WarpPlaceholders.registerWarp("rating_amount", handler -> {
            Warp warp = WarpPlaceholders.getWarp(handler);
            if (warp == null) {
                return empty;
            }
            return String.valueOf(warp.getRatingAmount());
        });
        WarpPlaceholders.registerWarp("visitors", handler -> {
            Warp warp = WarpPlaceholders.getWarp(handler);
            if (warp == null) {
                return empty;
            }
            return String.valueOf(warp.getVisits());
        });
        WarpPlaceholders.registerWarp("visitors_unique", handler -> {
            Warp warp = WarpPlaceholders.getWarp(handler);
            if (warp == null) {
                return empty;
            }
            return String.valueOf(warp.getUniqueVisits());
        });
        WarpPlaceholders.registerWarp("favorites", handler -> {
            Warp warp = WarpPlaceholders.getWarp(handler);
            if (warp == null) {
                return empty;
            }
            return String.valueOf(warp.getFavorites());
        });
        WarpPlaceholders.registerWarp("icon", handler -> {
            Warp warp = WarpPlaceholders.getWarp(handler);
            if (warp == null) {
                return empty;
            }
            return warp.getIcon().name().toLowerCase();
        });
        WarpPlaceholders.registerWarp("blacklisted", handler -> {
            Warp warp = WarpPlaceholders.getWarp(handler);
            if (warp == null) {
                return empty;
            }
            return String.valueOf(warp.getAccessList(AccessList.BLACKLIST).size());
        });
        WarpPlaceholders.registerWarp("whitelisted", handler -> {
            Warp warp = WarpPlaceholders.getWarp(handler);
            if (warp == null) {
                return empty;
            }
            return String.valueOf(warp.getAccessList(AccessList.WHITELIST).size());
        });
        WarpPlaceholders.registerWarp("given_rating_decimal", handler -> {
            Player player = handler.raw(Player.class);
            if (player == null) {
                return empty;
            }
            Warp warp = WarpPlaceholders.getWarp(handler);
            if (warp == null) {
                return empty;
            }
            Integer rating = warp.getAllRatings().get(player.getUniqueId());
            return rating == null ? "" : WarpPlaceholders.format(rating);
        });
        WarpPlaceholders.registerWarp("given_rating_stars", handler -> {
            Player player = handler.raw(Player.class);
            if (player == null) {
                return empty;
            }
            Warp warp = WarpPlaceholders.getWarp(handler);
            if (warp == null) {
                return empty;
            }
            Integer rating = warp.getAllRatings().get(player.getUniqueId());
            return rating == null ? AxPlayerWarps.LANG.getString("placeholders.no-rating") : StarUtils.getFormatted(rating.intValue(), 5);
        });
    }

    @Nullable
    private static Warp getWarp(PlaceholderContext handler) throws PlaceholderException {
        Warp warp = handler.raw(Warp.class);
        if (warp == null) {
            warp = (Warp)handler.argument("warp");
        }
        return warp;
    }

    private static void registerWarp(String placeholder, ThrowingFunction<PlaceholderContext, String, PlaceholderException> parser) {
        PlaceholderHandler.register(placeholder, parser, false);
        PlaceholderHandler.register("<warp>_" + placeholder, new PlaceholderArguments(warpArg), parser, true);
    }
}

