/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.libs.gui;

import com.artillexstudios.axplayerwarps.libs.gui.GuiFrame;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class GuiUpdater {
    private static ScheduledExecutorService service = null;
    private static final AtomicInteger atomicInteger = new AtomicInteger();

    public static void start() {
        if (service != null) {
            return;
        }
        service = Executors.newSingleThreadScheduledExecutor();
        service.scheduleAtFixedRate(() -> {
            try {
                Set<GuiFrame> set = GuiFrame.openedGuis;
                synchronized (set) {
                    Iterator<GuiFrame> it = GuiFrame.openedGuis.iterator();
                    while (it.hasNext()) {
                        int num;
                        GuiFrame guiFrame = it.next();
                        if (!guiFrame.player.getOpenInventory().getTopInventory().equals((Object)guiFrame.gui.getInventory())) {
                            it.remove();
                            continue;
                        }
                        if (guiFrame.getUpdateTicks() <= 0 || (num = atomicInteger.getAndIncrement()) % guiFrame.getUpdateTicks() != 0) continue;
                        guiFrame.update();
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }, 50L, 50L, TimeUnit.MILLISECONDS);
    }

    public static void stop() {
        if (service == null) {
            return;
        }
        service.shutdown();
    }
}

