/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.libs.axapi.nms.v1_21_R7_paper;

import com.artillexstudios.axplayerwarps.libs.axapi.utils.logging.LogUtils;
import com.google.common.base.Preconditions;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.SnbtPrinterTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.datafix.fixes.References;
import org.bukkit.Material;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;

public enum ItemStackSerializer {
    INSTANCE;


    public byte[] serializeAsBytes(ItemStack itemStack) {
        byte[] byArray;
        Preconditions.checkArgument((itemStack != null ? 1 : 0) != 0, (Object)"Can't serialise a null itemstack!");
        Preconditions.checkArgument((itemStack.getType() != Material.AIR ? 1 : 0) != 0, (Object)"Can't serialise air!");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            CompoundTag compoundTag = (CompoundTag)net.minecraft.world.item.ItemStack.CODEC.encodeStart((DynamicOps)MinecraftServer.getServer().registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)CraftItemStack.asNMSCopy((ItemStack)itemStack)).getOrThrow();
            compoundTag.putInt("DataVersion", SharedConstants.getCurrentVersion().dataVersion().version());
            NbtIo.writeCompressed((CompoundTag)compoundTag, (OutputStream)outputStream);
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        outputStream.close();
        return byArray;
    }

    public ItemStack deserializeFromBytes(byte[] bytes) {
        CraftItemStack craftItemStack;
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        try {
            CompoundTag compound = NbtIo.readCompressed((InputStream)stream, (NbtAccounter)NbtAccounter.unlimitedHeap());
            int dataVersion = compound.getIntOr("DataVersion", 0);
            CompoundTag converted = (CompoundTag)MinecraftServer.getServer().fixerUpper.update(References.ITEM_STACK, new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)compound), dataVersion, SharedConstants.getCurrentVersion().dataVersion().version()).getValue();
            net.minecraft.world.item.ItemStack minecraftStack = (net.minecraft.world.item.ItemStack)net.minecraft.world.item.ItemStack.CODEC.parse((DynamicOps)MinecraftServer.getServer().registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)converted).getOrThrow();
            craftItemStack = CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)minecraftStack);
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        stream.close();
        return craftItemStack;
    }

    public String serializeAsSnbt(ItemStack itemStack) {
        Preconditions.checkArgument((itemStack != null ? 1 : 0) != 0, (Object)"Can't serialise a null itemstack!");
        Preconditions.checkArgument((itemStack.getType() != Material.AIR ? 1 : 0) != 0, (Object)"Can't serialise air!");
        CompoundTag compoundTag = (CompoundTag)net.minecraft.world.item.ItemStack.CODEC.encodeStart((DynamicOps)MinecraftServer.getServer().registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)CraftItemStack.asNMSCopy((ItemStack)itemStack)).getOrThrow();
        compoundTag.putInt("DataVersion", SharedConstants.getCurrentVersion().dataVersion().version());
        return new SnbtPrinterTagVisitor().visit((Tag)compoundTag);
    }

    public ItemStack deserializeFromSnbt(String snbt) {
        try {
            CompoundTag parsed = TagParser.parseCompoundFully((String)snbt);
            int dataVersion = parsed.getIntOr("DataVersion", 0);
            CompoundTag converted = (CompoundTag)MinecraftServer.getServer().fixerUpper.update(References.ITEM_STACK, new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)parsed), dataVersion, SharedConstants.getCurrentVersion().dataVersion().version()).getValue();
            net.minecraft.world.item.ItemStack minecraftStack = (net.minecraft.world.item.ItemStack)net.minecraft.world.item.ItemStack.CODEC.parse((DynamicOps)MinecraftServer.getServer().registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)converted).getOrThrow();
            return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)minecraftStack);
        }
        catch (CommandSyntaxException exception) {
            LogUtils.error("Failed to parse SNBT into an ItemStack! Please, check out the exception for more details!", new Object[]{exception});
            throw new RuntimeException(exception);
        }
    }
}

