/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.guis;

import com.artillexstudios.axplayerwarps.AxPlayerWarps;
import com.artillexstudios.axplayerwarps.database.impl.Base;
import com.artillexstudios.axplayerwarps.enums.AccessList;
import com.artillexstudios.axplayerwarps.input.InputManager;
import com.artillexstudios.axplayerwarps.libs.axapi.config.Config;
import com.artillexstudios.axplayerwarps.libs.axapi.libs.boostedyaml.settings.dumper.DumperSettings;
import com.artillexstudios.axplayerwarps.libs.axapi.libs.boostedyaml.settings.general.GeneralSettings;
import com.artillexstudios.axplayerwarps.libs.axapi.libs.boostedyaml.settings.loader.LoaderSettings;
import com.artillexstudios.axplayerwarps.libs.axapi.libs.boostedyaml.settings.updater.UpdaterSettings;
import com.artillexstudios.axplayerwarps.libs.axapi.nms.wrapper.ServerPlayerWrapper;
import com.artillexstudios.axplayerwarps.libs.axapi.placeholders.PlaceholderHandler;
import com.artillexstudios.axplayerwarps.libs.axapi.scheduler.Scheduler;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.ItemBuilder;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.PlayerTextures;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.StringUtils;
import com.artillexstudios.axplayerwarps.libs.gui.GuiFrame;
import com.artillexstudios.axplayerwarps.libs.gui.actions.GuiActions;
import com.artillexstudios.axplayerwarps.libs.gui.item.AxGuiItem;
import com.artillexstudios.axplayerwarps.user.Users;
import com.artillexstudios.axplayerwarps.user.WarpUser;
import com.artillexstudios.axplayerwarps.warps.Warp;
import com.artillexstudios.gui.builder.gui.PaginatedBuilder;
import com.artillexstudios.gui.guis.Gui;
import com.artillexstudios.gui.guis.GuiItem;
import com.artillexstudios.gui.guis.PaginatedGui;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;

public class WhitelistGui
extends GuiFrame {
    private static final Config GUI = new Config(new File(AxPlayerWarps.getInstance().getDataFolder(), "guis/whitelist.yml"), AxPlayerWarps.getInstance().getResource("guis/whitelist.yml"), GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().build(), DumperSettings.DEFAULT, UpdaterSettings.builder().build());
    private final PaginatedGui gui;
    private final Warp warp;
    private final WarpUser user;
    private static final AccessList al = AccessList.WHITELIST;

    public WhitelistGui(Player player, Warp warp) {
        super(GUI.getInt("auto-update-ticks", -1), GUI, player);
        this.user = Users.get(player);
        this.warp = warp;
        this.gui = ((PaginatedBuilder)((PaginatedBuilder)((PaginatedBuilder)Gui.paginated().disableAllInteractions()).title(StringUtils.format(GUI.getString("title", ""), Map.of("%warp%", warp.getName())))).rows(GUI.getInt("rows", 5))).pageSize(GUI.getInt("page-size", 21)).create();
        this.addPlaceholderParameter(warp);
        this.setGui(this.gui);
        this.user.addGui(this);
    }

    public static boolean reload() {
        return GUI.reload();
    }

    @Override
    public void open() {
        this.createItem("add", (InventoryClickEvent event) -> {
            GuiActions.run(this.player, this, event, this.file.getStringList("add.actions"));
            if (event.isRightClick() && event.isShiftClick()) {
                AxPlayerWarps.getThreadedQueue().submit(() -> {
                    AxPlayerWarps.getDatabase().clearList(this.warp, al);
                    AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)this.player, al.name().toLowerCase() + ".clear", new TagResolver[0]);
                    this.open();
                });
                return;
            }
            InputManager.getInput(this.player, "add-player", result -> {
                if (result.equalsIgnoreCase(this.player.getName())) {
                    AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)this.player, "errors." + al.name().toLowerCase() + "-self", new TagResolver[0]);
                    this.open();
                    return;
                }
                AxPlayerWarps.getThreadedQueue().submit(() -> {
                    UUID uuid = AxPlayerWarps.getDatabase().getUUIDFromName((String)result);
                    if (uuid == null) {
                        AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)this.player, "errors.player-not-found", new TagResolver[0]);
                    } else {
                        AxPlayerWarps.getDatabase().addToList(this.warp, al, Bukkit.getOfflinePlayer((UUID)uuid));
                        AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)this.player, al.name().toLowerCase() + ".add", Map.of("%player%", result));
                    }
                    Scheduler.get().run(() -> this.open());
                });
            });
        });
        this.load().thenRun(() -> {
            this.updateTitle();
            this.gui.open((HumanEntity)this.player);
        });
    }

    @Override
    public void update() {
        this.load().thenRun(() -> this.gui.update());
    }

    public CompletableFuture<Void> load() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        AxPlayerWarps.getThreadedQueue().submit(() -> {
            this.gui.clearPageItems();
            for (Base.AccessPlayer accessPlayer : this.warp.getAccessList(al)) {
                ServerPlayerWrapper wrapper;
                PlayerTextures textures;
                Player pl;
                ItemBuilder builder = ItemBuilder.create(this.file.getSection(al.getRoute()));
                if (builder.get().getType() == Material.PLAYER_HEAD && (pl = Bukkit.getPlayer((UUID)this.warp.getOwner())) != null && (textures = (wrapper = ServerPlayerWrapper.wrap(pl)).textures()).texture() != null) {
                    builder.setTextureValue(textures.texture());
                }
                builder.setName(PlaceholderHandler.parse(GUI.getString(al.getRoute() + ".name"), accessPlayer, this.player));
                ArrayList<String> lore = new ArrayList<String>(GUI.getStringList(al.getRoute() + ".lore"));
                lore.replaceAll(s -> PlaceholderHandler.parse(GUI.getString(al.getRoute() + ".name"), accessPlayer, this.player));
                builder.setLore(lore);
                this.gui.addItem((GuiItem)new AxGuiItem(builder.get(), event -> AxPlayerWarps.getThreadedQueue().submit(() -> {
                    AxPlayerWarps.getDatabase().removeFromList(this.warp, al, accessPlayer.player());
                    AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)this.player, al.name().toLowerCase() + ".remove", Map.of("%player%", accessPlayer.name()));
                    this.open();
                })));
            }
            Scheduler.get().run(scheduledTask -> future.complete(null));
        });
        return future;
    }
}

