/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.guis;

import com.artillexstudios.axplayerwarps.AxPlayerWarps;
import com.artillexstudios.axplayerwarps.guis.RateWarpGui;
import com.artillexstudios.axplayerwarps.libs.axapi.config.Config;
import com.artillexstudios.axplayerwarps.libs.axapi.libs.boostedyaml.settings.dumper.DumperSettings;
import com.artillexstudios.axplayerwarps.libs.axapi.libs.boostedyaml.settings.general.GeneralSettings;
import com.artillexstudios.axplayerwarps.libs.axapi.libs.boostedyaml.settings.loader.LoaderSettings;
import com.artillexstudios.axplayerwarps.libs.axapi.libs.boostedyaml.settings.updater.UpdaterSettings;
import com.artillexstudios.axplayerwarps.libs.axapi.nms.wrapper.ServerPlayerWrapper;
import com.artillexstudios.axplayerwarps.libs.axapi.scheduler.Scheduler;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.ItemBuilder;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.PlayerTextures;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.StringUtils;
import com.artillexstudios.axplayerwarps.libs.gui.GuiFrame;
import com.artillexstudios.axplayerwarps.libs.gui.item.AxGuiItem;
import com.artillexstudios.axplayerwarps.user.Users;
import com.artillexstudios.axplayerwarps.user.WarpUser;
import com.artillexstudios.axplayerwarps.warps.Warp;
import com.artillexstudios.gui.builder.gui.PaginatedBuilder;
import com.artillexstudios.gui.guis.Gui;
import com.artillexstudios.gui.guis.GuiItem;
import com.artillexstudios.gui.guis.PaginatedGui;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class RecentsGui
extends GuiFrame {
    private static final Config GUI = new Config(new File(AxPlayerWarps.getInstance().getDataFolder(), "guis/recents.yml"), AxPlayerWarps.getInstance().getResource("guis/recents.yml"), GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().build(), DumperSettings.DEFAULT, UpdaterSettings.builder().build());
    private final PaginatedGui gui;
    private final WarpUser user;

    public RecentsGui(Player player) {
        super(GUI.getInt("auto-update-ticks", -1), GUI, player);
        this.user = Users.get(player);
        this.gui = ((PaginatedBuilder)((PaginatedBuilder)((PaginatedBuilder)Gui.paginated().disableAllInteractions()).title((Component)Component.empty())).rows(GUI.getInt("rows", 5))).pageSize(GUI.getInt("page-size", 21)).create();
        this.setGui(this.gui);
        this.user.addGui(this);
    }

    @Override
    public void updateTitle() {
        this.gui.updateTitle(StringUtils.format(GUI.getString("title", ""), new HashMap<String, CallSite>(Map.of("%page%", "" + this.gui.getCurrentPageNum(), "%pages%", "" + Math.max(1, this.gui.getPagesNum())))));
    }

    public static boolean reload() {
        return GUI.reload();
    }

    @Override
    public void open() {
        this.load().thenRun(() -> {
            this.updateTitle();
            this.gui.open((HumanEntity)this.player);
        });
    }

    @Override
    public void update() {
        this.load().thenRun(() -> this.gui.update());
    }

    public CompletableFuture<Void> load() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        AxPlayerWarps.getThreadedQueue().submit(() -> {
            this.gui.clearPageItems();
            for (Warp warp : AxPlayerWarps.getDatabase().getRecentWarps(this.player)) {
                ServerPlayerWrapper wrapper;
                PlayerTextures textures;
                Player pl;
                Material icon = warp.getIcon();
                ItemBuilder builder = ItemBuilder.create(new ItemStack(icon));
                builder.setName(this.parseText(GUI.getString("warp.name"), warp));
                String[] description = warp.getDescription().split("\n", AxPlayerWarps.CONFIG.getInt("warp-description.max-lines", 3));
                ArrayList<String> lore = new ArrayList<String>();
                ArrayList<String> lore2 = new ArrayList<String>(GUI.getStringList("warp.lore"));
                for (int i = 0; i < lore2.size(); ++i) {
                    String line = (String)lore2.get(i);
                    if (!line.contains("%description%")) {
                        lore.add(line);
                        continue;
                    }
                    for (int j = description.length - 1; j >= 0; --j) {
                        lore.add(i, line.replace("%description%", description[j]));
                    }
                }
                builder.setLore(this.parseText(lore, warp));
                if (icon == Material.PLAYER_HEAD && (pl = Bukkit.getPlayer((UUID)warp.getOwner())) != null && (textures = (wrapper = ServerPlayerWrapper.wrap(pl)).textures()).texture() != null) {
                    builder.setTextureValue(textures.texture());
                }
                this.gui.addItem((GuiItem)new AxGuiItem(builder.get(), event -> {
                    if (event.isLeftClick()) {
                        warp.teleportPlayer(this.player);
                    } else {
                        new RateWarpGui(this.player, warp).open();
                    }
                }));
            }
            Scheduler.get().run(scheduledTask -> future.complete(null));
        });
        return future;
    }
}

