/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.commands;

import com.artillexstudios.axplayerwarps.AxPlayerWarps;
import com.artillexstudios.axplayerwarps.commands.AdminCommand;
import com.artillexstudios.axplayerwarps.commands.MainCommand;
import com.artillexstudios.axplayerwarps.commands.annotations.AllWarps;
import com.artillexstudios.axplayerwarps.commands.annotations.OwnWarps;
import com.artillexstudios.axplayerwarps.libs.lamp.bukkit.BukkitCommandActor;
import com.artillexstudios.axplayerwarps.libs.lamp.bukkit.BukkitCommandHandler;
import com.artillexstudios.axplayerwarps.libs.lamp.exception.CommandErrorException;
import com.artillexstudios.axplayerwarps.libs.lamp.orphan.Orphans;
import com.artillexstudios.axplayerwarps.utils.CommandMessages;
import com.artillexstudios.axplayerwarps.warps.Warp;
import com.artillexstudios.axplayerwarps.warps.WarpManager;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.bukkit.plugin.Plugin;

public class CommandManager {
    private static BukkitCommandHandler handler = null;

    public static void load() {
        handler = BukkitCommandHandler.create((Plugin)AxPlayerWarps.getInstance());
        handler.getTranslator().add(new CommandMessages());
        handler.setLocale(Locale.of("en", "US"));
        handler.getAutoCompleter().registerSuggestionFactory(parameter -> {
            if (parameter.hasAnnotation(AllWarps.class)) {
                return (args, sender, command) -> WarpManager.getWarps().stream().map(Warp::getName).toList();
            }
            if (parameter.hasAnnotation(OwnWarps.class)) {
                return (args, sender, command) -> WarpManager.getWarps().stream().filter(warp -> warp.getOwner().equals(sender.getUniqueId())).map(Warp::getName).toList();
            }
            return null;
        });
        handler.registerValueResolver(Warp.class, resolver -> {
            String str = resolver.popForParameter();
            Optional<Warp> opt = WarpManager.getWarps().stream().filter(warp -> warp.getName().equals(str)).findAny();
            if (opt.isEmpty()) {
                opt = WarpManager.getWarps().stream().filter(warp -> warp.getName().equalsIgnoreCase(str)).findAny();
            }
            if (opt.isEmpty()) {
                AxPlayerWarps.MESSAGEUTILS.sendLang(resolver.actor().as(BukkitCommandActor.class).getSender(), "errors.not-found", Map.of("%warp%", str));
                throw new CommandErrorException();
            }
            return opt.get();
        });
        CommandManager.reload();
    }

    public static void reload() {
        handler.unregisterAllCommands();
        handler.register(Orphans.path((String[])AxPlayerWarps.CONFIG.getStringList("main-command-aliases").toArray(String[]::new)).handler(new MainCommand()));
        handler.register(Orphans.path((String[])AxPlayerWarps.CONFIG.getStringList("admin-command-aliases").toArray(String[]::new)).handler(new AdminCommand()));
        handler.registerBrigadier();
    }
}

