/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.libs.gui.utils;

import com.artillexstudios.axplayerwarps.libs.axapi.libs.boostedyaml.block.implementation.Section;
import com.artillexstudios.axplayerwarps.libs.axapi.placeholders.PlaceholderHandler;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.ItemBuilder;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.NumberUtils;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.placeholder.Placeholder;
import com.artillexstudios.axplayerwarps.libs.gui.placeholders.PlaceholderAPIParser;
import com.artillexstudios.axplayerwarps.libs.gui.placeholders.PlaceholderManager;
import com.artillexstudios.axplayerwarps.libs.gui.replacements.Replacements;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBuilderUtil {
    @NotNull
    public static ItemBuilder newBuilder(@Nullable Player player, @NotNull Section section) {
        return ItemBuilderUtil.newBuilder(player, section, new Replacements(), null);
    }

    @NotNull
    public static ItemBuilder newBuilder(@Nullable Player player, @NotNull Section section, Placeholder placeholder) {
        return ItemBuilderUtil.newBuilder(player, section, new Replacements(), placeholder);
    }

    @NotNull
    public static ItemBuilder newBuilder(@Nullable Player player, @NotNull Section section, Replacements replacements, Placeholder placeholder) {
        Map<Object, Object> mapped = ItemBuilderUtil.mapSection(section);
        mapped.remove("name");
        mapped.remove("lore");
        mapped.remove("amount");
        ItemBuilder builder = ItemBuilder.create(mapped, TagResolver.resolver(new TagResolver[0]));
        PlaceholderManager placeholderManager = Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null ? new PlaceholderAPIParser() : new PlaceholderManager(){};
        section.getOptionalString("name").ifPresent(name -> {
            name = placeholderManager.setPlaceholders((OfflinePlayer)player, (String)name);
            if (placeholder != null) {
                name = placeholder.parse(player, (String)name);
            }
            name = PlaceholderHandler.parse(name, player);
            builder.setName((String)name, replacements.get());
        });
        section.getOptionalStringList("lore").ifPresent(lore -> {
            lore = placeholderManager.setPlaceholders((OfflinePlayer)player, (List<String>)lore);
            if (placeholder != null) {
                lore.replaceAll(s -> placeholder.parse(player, (String)s));
            }
            lore.replaceAll(s -> PlaceholderHandler.parse(s, player));
            builder.setLore((List<String>)lore, replacements.get());
        });
        section.getOptionalString("amount").ifPresent(amount -> {
            amount = placeholderManager.setPlaceholders((OfflinePlayer)player, (String)amount);
            if (placeholder != null) {
                amount = placeholder.parse(player, (String)amount);
            }
            amount = PlaceholderHandler.parse(amount, player);
            for (Map.Entry<String, String> entry : replacements.get().entrySet()) {
                amount = amount.replace(entry.getKey(), entry.getValue());
            }
            if (!NumberUtils.isInt(amount)) {
                amount = "1";
            }
            builder.amount(Math.max(1, Math.min(64, Integer.parseInt(amount))));
        });
        return builder;
    }

    @NotNull
    @Contract(value="_ -> new")
    public static ItemBuilder newBuilder(@NotNull ItemStack itemStack) {
        return ItemBuilder.create(itemStack);
    }

    private static Map<Object, Object> mapSection(Section section) {
        Set<Object> keys = section.getKeys();
        HashMap<Object, Object> map = new HashMap<Object, Object>(keys.size());
        for (Object key : keys) {
            map.put(key.toString(), section.get(key.toString()));
        }
        return map;
    }
}

