/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.input;

import com.artillexstudios.axplayerwarps.AxPlayerWarps;
import com.artillexstudios.axplayerwarps.input.InputListener;
import com.artillexstudios.axplayerwarps.input.InputType;
import com.artillexstudios.axplayerwarps.libs.axapi.gui.AnvilInput;
import com.artillexstudios.axplayerwarps.libs.axapi.gui.SignInput;
import com.artillexstudios.axplayerwarps.libs.axapi.items.WrappedItemStack;
import com.artillexstudios.axplayerwarps.libs.axapi.libs.boostedyaml.block.implementation.Section;
import com.artillexstudios.axplayerwarps.libs.axapi.scheduler.Scheduler;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.ItemBuilder;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.StringUtils;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class InputManager {
    public static void getInput(Player player, String route, Consumer<String> consumer) {
        Section section = AxPlayerWarps.INPUT.getSection(route);
        switch (InputType.valueOf(section.getString("type").toUpperCase(Locale.ENGLISH))) {
            case SIGN: {
                InputManager.openSign(player, section, consumer);
                break;
            }
            case ANVIL: {
                InputManager.openAnvil(player, section, consumer);
                break;
            }
            case CHAT: {
                InputManager.openChat(player, section, consumer);
            }
        }
    }

    private static void openSign(Player player, Section section, Consumer<String> consumer) {
        new SignInput(player, (Component[])StringUtils.formatList(section.getStringList("sign"), new TagResolver[0]).toArray(Component[]::new), (player1, result) -> {
            try {
                String res = result[0];
                if (res.isBlank()) {
                    consumer.accept("");
                    return;
                }
                Scheduler.get().run(() -> consumer.accept(res));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }).open();
    }

    private static void openAnvil(Player player, Section section, Consumer<String> consumer) {
        AtomicBoolean ended = new AtomicBoolean(false);
        new AnvilInput(player, WrappedItemStack.wrap(ItemBuilder.create(section.getSection("anvil.item")).get()), StringUtils.format(section.getString("anvil.title"), new TagResolver[0]), clickEvent -> {
            clickEvent.setCancelled(true);
            if (ended.get()) {
                return;
            }
            if (clickEvent.getSlot() != 2) {
                return;
            }
            ItemStack item = clickEvent.getInventory().getItem(2);
            String res = item.getItemMeta().getDisplayName();
            clickEvent.getInventory().clear();
            Scheduler.get().run(() -> consumer.accept(res));
            ended.set(true);
        }, closeEvent -> {
            closeEvent.getInventory().clear();
            if (ended.get()) {
                return;
            }
            Scheduler.get().run(() -> consumer.accept(""));
        }).open();
    }

    private static void openChat(Player player, Section section, Consumer<String> consumer) {
        player.closeInventory();
        player.sendMessage(String.join((CharSequence)"\n", StringUtils.formatListToString(section.getStringList("chat"), new TagResolver[0])));
        InputListener.getInputPlayers().put(player, consumer);
    }
}

