/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.hooks.currency;

import com.artillexstudios.axplayerwarps.AxPlayerWarps;
import com.artillexstudios.axplayerwarps.hooks.currency.CurrencyHook;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.kingdoms.constants.player.KingdomPlayer;

public class KingdomsXHook
implements CurrencyHook {
    @Override
    public void setup() {
    }

    @Override
    public String getName() {
        return "KingdomsX";
    }

    @Override
    public String getDisplayName() {
        return AxPlayerWarps.CURRENCIES.getString("currencies.KingdomsX.name");
    }

    @Override
    public boolean worksOffline() {
        return true;
    }

    @Override
    public boolean usesDouble() {
        return false;
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public double getBalance(@NotNull UUID player) {
        KingdomPlayer kingdomPlayer = KingdomPlayer.getKingdomPlayer((UUID)player);
        if (kingdomPlayer.getKingdom() == null) {
            return 0.0;
        }
        return kingdomPlayer.getKingdom().getResourcePoints();
    }

    @Override
    public void giveBalance(@NotNull UUID player, double amount) {
        KingdomPlayer kingdomPlayer = KingdomPlayer.getKingdomPlayer((UUID)player);
        kingdomPlayer.getKingdom().addResourcePoints((long)amount);
    }

    @Override
    public void takeBalance(@NotNull UUID player, double amount) {
        KingdomPlayer kingdomPlayer = KingdomPlayer.getKingdomPlayer((UUID)player);
        kingdomPlayer.getKingdom().addResourcePoints((long)(amount * -1.0));
    }
}

