/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.guis;

import com.artillexstudios.axplayerwarps.AxPlayerWarps;
import com.artillexstudios.axplayerwarps.input.InputManager;
import com.artillexstudios.axplayerwarps.libs.axapi.config.Config;
import com.artillexstudios.axplayerwarps.libs.axapi.libs.boostedyaml.settings.dumper.DumperSettings;
import com.artillexstudios.axplayerwarps.libs.axapi.libs.boostedyaml.settings.general.GeneralSettings;
import com.artillexstudios.axplayerwarps.libs.axapi.libs.boostedyaml.settings.loader.LoaderSettings;
import com.artillexstudios.axplayerwarps.libs.axapi.libs.boostedyaml.settings.updater.UpdaterSettings;
import com.artillexstudios.axplayerwarps.libs.axapi.scheduler.Scheduler;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.NumberUtils;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.StringUtils;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.placeholder.Placeholder;
import com.artillexstudios.axplayerwarps.libs.gui.GuiFrame;
import com.artillexstudios.axplayerwarps.libs.gui.actions.GuiActions;
import com.artillexstudios.axplayerwarps.placeholders.Placeholders;
import com.artillexstudios.axplayerwarps.user.Users;
import com.artillexstudios.axplayerwarps.user.WarpUser;
import com.artillexstudios.axplayerwarps.utils.StarUtils;
import com.artillexstudios.axplayerwarps.warps.Warp;
import com.artillexstudios.gui.builder.gui.SimpleBuilder;
import com.artillexstudios.gui.guis.Gui;
import java.io.File;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;

public class RateWarpGui
extends GuiFrame {
    private static final Config GUI = new Config(new File(AxPlayerWarps.getInstance().getDataFolder(), "guis/rate-warp.yml"), AxPlayerWarps.getInstance().getResource("guis/rate-warp.yml"), GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().build(), DumperSettings.DEFAULT, UpdaterSettings.builder().build());
    private final Gui gui;
    private final Warp warp;
    private final WarpUser user;

    public RateWarpGui(Player player, Warp warp) {
        super(GUI.getInt("auto-update-ticks", -1), GUI, player);
        this.user = Users.get(player);
        this.setPlaceholder(new Placeholder((pl, s) -> {
            Integer rating = warp.getAllRatings().get(player.getUniqueId());
            s = s.replace("%given_rating_decimal%", rating == null ? "" : Placeholders.df.format(rating));
            s = s.replace("%given_rating_stars%", rating == null ? AxPlayerWarps.LANG.getString("placeholders.no-rating") : StarUtils.getFormatted(rating.intValue(), 5));
            s = Placeholders.parse(warp, (OfflinePlayer)pl, s);
            return s;
        }));
        this.warp = warp;
        this.gui = ((SimpleBuilder)((SimpleBuilder)((SimpleBuilder)Gui.gui().disableAllInteractions()).title(StringUtils.format(GUI.getString("title", ""), Map.of("%warp%", warp.getName())))).rows(GUI.getInt("rows", 5))).create();
        this.setGui(this.gui);
        this.user.addGui(this);
    }

    public static boolean reload() {
        return GUI.reload();
    }

    @Override
    public void open() {
        List<String> slots = this.file.getBackingDocument().getStringList("favorite.slot");
        List<Integer> slotOverrides = RateWarpGui.getSlots(slots.isEmpty() ? List.of(this.file.getString("favorite.slot")) : slots);
        boolean isFavorite = this.user.getFavorites().contains(this.warp);
        this.createItem("favorite." + (isFavorite ? "favorite" : "not-favorite"), (InventoryClickEvent event) -> {
            GuiActions.run(this.player, this, this.file.getStringList("favorite.actions"));
            AxPlayerWarps.getThreadedQueue().submit(() -> {
                if (isFavorite) {
                    AxPlayerWarps.getDatabase().removeFromFavorites(this.player, this.warp);
                    AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)this.player, "favorite.remove", Map.of("%warp%", this.warp.getName()));
                } else {
                    AxPlayerWarps.getDatabase().addToFavorites(this.player, this.warp);
                    AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)this.player, "favorite.add", Map.of("%warp%", this.warp.getName()));
                }
                Scheduler.get().run(() -> this.open());
            });
        }, slotOverrides);
        this.createItem("teleport", (InventoryClickEvent event) -> {
            GuiActions.run(this.player, this, this.file.getStringList("teleport.actions"));
            this.warp.teleportPlayer(this.player);
        });
        this.createItem("rate", (InventoryClickEvent event) -> {
            GuiActions.run(this.player, this, this.file.getStringList("rate.actions"));
            if (event.isRightClick()) {
                AxPlayerWarps.getThreadedQueue().submit(() -> {
                    AxPlayerWarps.getDatabase().removeRating(this.player, this.warp);
                    AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)this.player, "rate.remove", new TagResolver[0]);
                    Scheduler.get().run(() -> this.open());
                });
            }
            if (event.isLeftClick()) {
                InputManager.getInput(this.player, "rate", result -> {
                    if (!NumberUtils.isInt(result)) {
                        AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)this.player, "errors.not-a-number", new TagResolver[0]);
                    } else {
                        int i = Math.max(1, Math.min(5, Integer.parseInt(result)));
                        AxPlayerWarps.getThreadedQueue().submit(() -> {
                            AxPlayerWarps.getDatabase().setRating(this.player, this.warp, i);
                            AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)this.player, "rate.add", Map.of("%rating%", "" + i));
                        });
                    }
                    Scheduler.get().run(() -> this.open());
                });
            }
        });
        this.gui.update();
        this.gui.open((HumanEntity)this.player);
    }
}

