/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.database;

import com.artillexstudios.axplayerwarps.category.Category;
import com.artillexstudios.axplayerwarps.database.impl.Base;
import com.artillexstudios.axplayerwarps.enums.AccessList;
import com.artillexstudios.axplayerwarps.hooks.currency.CurrencyHook;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.Pair;
import com.artillexstudios.axplayerwarps.warps.Warp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public interface Database {
    public String getType();

    public void setup();

    public int getPlayerId(OfflinePlayer var1);

    public int getPlayerId(UUID var1);

    public String getPlayerName(UUID var1);

    @Nullable
    public UUID getUUIDFromName(String var1);

    public int getWorldId(String var1);

    public int getWorldId(World var1);

    public UUID getUUIDFromId(int var1);

    public Pair<UUID, String> getUUIDAndNameFromId(int var1);

    public String getWorldFromId(int var1);

    public int getCategoryId(String var1);

    public Category getCategoryFromId(int var1);

    public int getCurrencyId(String var1);

    public CurrencyHook getCurrencyFromId(int var1);

    public int getMaterialId(Material var1);

    public int getMaterialId(String var1);

    public Material getMaterialFromId(int var1);

    public int createWarp(OfflinePlayer var1, Location var2, String var3);

    public void updateWarp(Warp var1);

    public void deleteWarp(Warp var1);

    public void setRating(Player var1, Warp var2, int var3);

    public void removeRating(Player var1, Warp var2);

    @Nullable
    public Integer getRating(Player var1, Warp var2);

    public Pair<Integer, Float> getRatings(Warp var1);

    public HashMap<UUID, Integer> getAllRatings(Warp var1);

    public void addToFavorites(Player var1, Warp var2);

    public void removeFromFavorites(Player var1, Warp var2);

    public void removeAllFavorites(Player var1);

    public int getFavorites(Warp var1);

    public int getFavorites(Player var1);

    public List<Warp> getFavoriteWarps(Player var1);

    public List<Warp> getRecentWarps(Player var1);

    public boolean isFavorite(Player var1, Warp var2);

    public void addVisit(Player var1, Warp var2);

    public int getVisits(Warp var1);

    public HashSet<UUID> getVisitors(Warp var1);

    public int getUniqueVisits(Warp var1);

    public boolean warpExists(String var1);

    public void addToList(Warp var1, AccessList var2, OfflinePlayer var3);

    public void removeFromList(Warp var1, AccessList var2, OfflinePlayer var3);

    public void clearList(Warp var1, AccessList var2);

    public boolean isOnList(Warp var1, AccessList var2, OfflinePlayer var3);

    public List<Base.AccessPlayer> getAccessList(Warp var1, AccessList var2);

    public void loadWarps();

    public void disable();
}

