/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.libs.axintegrations.integration.prices.implementation;

import com.artillexstudios.axplayerwarps.libs.axintegrations.integration.prices.PriceIntegration;
import com.artillexstudios.axplayerwarps.libs.axintegrations.plugin.RequiredPlugin;
import fr.maxlego08.zshop.api.ShopManager;
import fr.maxlego08.zshop.api.buttons.ItemButton;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.RegisteredServiceProvider;

public final class ZShopPriceIntegration
implements PriceIntegration {
    private final ShopManager shopManager;

    public ZShopPriceIntegration() {
        RegisteredServiceProvider shopManager = Bukkit.getServicesManager().getRegistration(ShopManager.class);
        this.shopManager = (ShopManager)shopManager.getProvider();
    }

    @Override
    public Double getPrice(ItemStack itemStack) {
        Optional button = this.shopManager.getItemButton(itemStack.getType());
        if (button.isEmpty()) {
            return null;
        }
        return ((ItemButton)button.get()).getSellPrice(itemStack.getAmount());
    }

    @Override
    public Double getPrice(ItemStack itemStack, long amount) {
        Optional button = this.shopManager.getItemButton(itemStack.getType());
        if (button.isEmpty()) {
            return null;
        }
        return ((ItemButton)button.get()).getSellPrice((int)amount);
    }

    @Override
    public Double getPrice(ItemStack itemStack, OfflinePlayer player) {
        Optional button = this.shopManager.getItemButton(player.getPlayer(), itemStack);
        if (button.isEmpty()) {
            return null;
        }
        return ((ItemButton)button.get()).getSellPrice(player.getPlayer(), itemStack.getAmount());
    }

    @Override
    public Double getPrice(ItemStack itemStack, long amount, OfflinePlayer player) {
        Optional button = this.shopManager.getItemButton(player.getPlayer(), itemStack);
        if (button.isEmpty()) {
            return null;
        }
        return ((ItemButton)button.get()).getSellPrice(player.getPlayer(), (int)amount);
    }

    @Override
    public RequiredPlugin[] requiredPlugins() {
        return new RequiredPlugin[]{RequiredPlugin.of("zShop")};
    }

    @Override
    public String id() {
        return "zshop";
    }
}

