/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.libs.axapi.config.adapters;

import com.artillexstudios.axplayerwarps.libs.axapi.config.adapters.MapConfigurationGetter;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.UncheckedUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Pattern;

public interface ConfigurationGetter {
    public <T> T get(String var1, Class<T> var2);

    default public <T> T anyOf(Function<String, T> function, String ... paths) {
        for (String path : paths) {
            T value = function.apply(path);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    default public Object getObject(String path) {
        return this.get(path, Object.class);
    }

    default public Boolean getBoolean(String path) {
        return this.get(path, Boolean.class);
    }

    default public String getString(String path) {
        return this.get(path, String.class);
    }

    default public Double getDouble(String path) {
        return this.get(path, Double.class);
    }

    default public Integer getInteger(String path) {
        return this.get(path, Integer.class);
    }

    default public Float getFloat(String path) {
        return this.get(path, Float.class);
    }

    default public Short getShort(String path) {
        return this.get(path, Short.class);
    }

    default public Byte getByte(String path) {
        return this.get(path, Byte.class);
    }

    default public <T> List<T> getList(String path) {
        return (List)UncheckedUtils.unsafeCast(this.get(path, List.class));
    }

    default public <T, Z> List<T> getList(String path, Function<Z, T> converter) {
        List list = (List)UncheckedUtils.unsafeCast(this.get(path, List.class));
        if (list == null) {
            return null;
        }
        ArrayList<T> newList = new ArrayList<T>(list.size());
        for (Object object : list) {
            newList.add(converter.apply(object));
        }
        return newList;
    }

    default public List<String> getStringList(String path) {
        return this.getList(path, Object::toString);
    }

    default public <T, Z> Map<T, Z> getMap(String path) {
        return (Map)UncheckedUtils.unsafeCast(this.get(path, Map.class));
    }

    default public MapConfigurationGetter getConfiguration(String path) {
        return new MapConfigurationGetter((Map)UncheckedUtils.unsafeCast(this.get(path, Map.class)));
    }

    default public MapConfigurationGetter getConfigurationSection(String path) {
        return new MapConfigurationGetter((Map)UncheckedUtils.unsafeCast(this.get(path, LinkedHashMap.class)));
    }

    default public <T, Z> Map<T, Z> getSection(String path) {
        return (Map)UncheckedUtils.unsafeCast(this.get(path, LinkedHashMap.class));
    }

    default public UUID getUUID(String path) {
        return this.get(path, UUID.class);
    }

    default public Long getLong(String path) {
        return this.get(path, Long.class);
    }

    default public BigDecimal getBigDecimal(String path) {
        return this.get(path, BigDecimal.class);
    }

    default public BigInteger getBigInteger(String path) {
        return this.get(path, BigInteger.class);
    }

    default public Pattern getPattern(String path) {
        return this.get(path, Pattern.class);
    }

    default public <T extends Enum<T>> T getEnum(String path, Class<T> clazz) {
        return (T)((Enum)this.get(path, clazz));
    }
}

