/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.zapper.repository;

import com.artillexstudios.axminions.libs.annotations.NotNull;
import java.net.URL;
import java.util.Objects;
import revxrsal.zapper.Dependency;
import revxrsal.zapper.repository.Repository;

public final class MavenRepository
implements Repository {
    private static final MavenRepository MAVEN_CENTRAL = new MavenRepository("https://repo1.maven.org/maven2/");
    private static final MavenRepository JITPACK = new MavenRepository("https://jitpack.io/");
    private static final MavenRepository MINECRAFT = new MavenRepository("https://libraries.minecraft.net/");
    private static final MavenRepository PAPER = new MavenRepository("https://papermc.io/repo/repository/maven-public/");
    private final String repoURL;

    @NotNull
    public static MavenRepository mavenCentral() {
        return MAVEN_CENTRAL;
    }

    @NotNull
    public static MavenRepository jitpack() {
        return JITPACK;
    }

    @NotNull
    public static MavenRepository minecraft() {
        return MINECRAFT;
    }

    @NotNull
    public static MavenRepository paper() {
        return PAPER;
    }

    @NotNull
    public static MavenRepository maven(@NotNull String url) {
        return new MavenRepository(url);
    }

    private MavenRepository(@NotNull String repoURL) {
        if (((String)repoURL).charAt(((String)repoURL).length() - 1) != '/') {
            repoURL = (String)repoURL + "/";
        }
        this.repoURL = repoURL;
    }

    public String getRepositoryURL() {
        return this.repoURL;
    }

    public String toString() {
        return this.getRepositoryURL();
    }

    @Override
    @NotNull
    public URL resolve(@NotNull Dependency dependency2) throws Exception {
        return new URL(this.repoURL + dependency2.getMavenPath());
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenRepository that = (MavenRepository)o;
        return Objects.equals(this.repoURL, that.repoURL);
    }

    public int hashCode() {
        return Objects.hashCode(this.repoURL);
    }
}

