/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.zapper.classloader;

import com.artillexstudios.axminions.libs.annotations.NotNull;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import revxrsal.zapper.classloader.URLClassLoaderWrapper;
import revxrsal.zapper.classloader.UnsafeUtil;

final class ByUnsafe
extends URLClassLoaderWrapper {
    private static final Class<? extends URLClassLoader> PL_CL_LOADER;
    private static BiFunction<URL[], ClassLoader, URLClassLoader> LOADER_FACTORY;
    private static Class<?> LIBRARY_LOADER;
    private final List<URL> urls;
    private final URLClassLoader loader;
    private final Collection<URL> unopenedURLs;
    private final List<URL> pathURLs;

    public ByUnsafe(@NotNull URLClassLoader loader) {
        this.loader = loader;
        ArrayList urls0 = null;
        if (PL_CL_LOADER.isAssignableFrom(loader.getClass())) {
            try {
                ClassLoader libraryLoader = (ClassLoader)UnsafeUtil.getFieldNullable(loader, "libraryLoader", PL_CL_LOADER);
                urls0 = new ArrayList();
            }
            catch (Exception libraryLoader) {
                // empty catch block
            }
        }
        this.urls = urls0;
        Object ucp = UnsafeUtil.getField(loader, "ucp", URLClassLoader.class);
        this.unopenedURLs = (Collection)UnsafeUtil.getField(ucp, UnsafeUtil.isJava8() ? "urls" : "unopenedUrls", ucp.getClass());
        this.pathURLs = (List)UnsafeUtil.getField(ucp, "path", ucp.getClass());
    }

    @Override
    public void addURL(@NotNull URL url, boolean remap) {
        if (remap && this.urls != null && LIBRARY_LOADER != null && LOADER_FACTORY != null) {
            this.urls.add(url);
            return;
        }
        this.unopenedURLs.add(url);
        this.pathURLs.add(url);
    }

    @Override
    public void flush() {
        if (this.urls != null && !this.urls.isEmpty()) {
            ArrayList<URL> urlsCopy = new ArrayList<URL>(this.urls);
            ClassLoader prevLoader = (ClassLoader)UnsafeUtil.getFieldNullable(this.loader, "libraryLoader", PL_CL_LOADER);
            if (prevLoader instanceof URLClassLoader) {
                URL[] prevUrls;
                for (URL url : prevUrls = ((URLClassLoader)prevLoader).getURLs()) {
                    if (urlsCopy.contains(url)) continue;
                    urlsCopy.add(url);
                }
            }
            URLClassLoader classLoader = LOADER_FACTORY == null ? new URLClassLoader(urlsCopy.toArray(new URL[0]), LIBRARY_LOADER.getClassLoader()) : LOADER_FACTORY.apply(urlsCopy.toArray(new URL[0]), LIBRARY_LOADER.getClassLoader());
            UnsafeUtil.setField(this.loader, "libraryLoader", PL_CL_LOADER, classLoader);
        }
    }

    static {
        try {
            PL_CL_LOADER = Class.forName("org.bukkit.plugin.java.PluginClassLoader").asSubclass(URLClassLoader.class);
            try {
                LIBRARY_LOADER = Class.forName("org.bukkit.plugin.java.LibraryLoader");
            }
            catch (Exception e) {
                LIBRARY_LOADER = null;
            }
            try {
                LOADER_FACTORY = (BiFunction)UnsafeUtil.getFieldReflection(null, "LIBRARY_LOADER_FACTORY", LIBRARY_LOADER);
            }
            catch (Exception e) {
                LOADER_FACTORY = null;
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

