/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.serializer.legacy;

import com.artillexstudios.axminions.libs.annotations.ApiStatus;
import com.artillexstudios.axminions.libs.annotations.NotNull;
import com.artillexstudios.axminions.libs.annotations.Unmodifiable;
import java.util.List;
import java.util.stream.Stream;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.format.TextFormat;
import net.kyori.adventure.text.serializer.legacy.CharacterAndFormatImpl;
import net.kyori.adventure.text.serializer.legacy.Reset;
import net.kyori.examination.Examinable;
import net.kyori.examination.ExaminableProperty;

@ApiStatus.NonExtendable
public interface CharacterAndFormat
extends Examinable {
    public static final CharacterAndFormat BLACK = CharacterAndFormat.characterAndFormat('0', (TextFormat)NamedTextColor.BLACK, true);
    public static final CharacterAndFormat DARK_BLUE = CharacterAndFormat.characterAndFormat('1', (TextFormat)NamedTextColor.DARK_BLUE, true);
    public static final CharacterAndFormat DARK_GREEN = CharacterAndFormat.characterAndFormat('2', (TextFormat)NamedTextColor.DARK_GREEN, true);
    public static final CharacterAndFormat DARK_AQUA = CharacterAndFormat.characterAndFormat('3', (TextFormat)NamedTextColor.DARK_AQUA, true);
    public static final CharacterAndFormat DARK_RED = CharacterAndFormat.characterAndFormat('4', (TextFormat)NamedTextColor.DARK_RED, true);
    public static final CharacterAndFormat DARK_PURPLE = CharacterAndFormat.characterAndFormat('5', (TextFormat)NamedTextColor.DARK_PURPLE, true);
    public static final CharacterAndFormat GOLD = CharacterAndFormat.characterAndFormat('6', (TextFormat)NamedTextColor.GOLD, true);
    public static final CharacterAndFormat GRAY = CharacterAndFormat.characterAndFormat('7', (TextFormat)NamedTextColor.GRAY, true);
    public static final CharacterAndFormat DARK_GRAY = CharacterAndFormat.characterAndFormat('8', (TextFormat)NamedTextColor.DARK_GRAY, true);
    public static final CharacterAndFormat BLUE = CharacterAndFormat.characterAndFormat('9', (TextFormat)NamedTextColor.BLUE, true);
    public static final CharacterAndFormat GREEN = CharacterAndFormat.characterAndFormat('a', (TextFormat)NamedTextColor.GREEN, true);
    public static final CharacterAndFormat AQUA = CharacterAndFormat.characterAndFormat('b', (TextFormat)NamedTextColor.AQUA, true);
    public static final CharacterAndFormat RED = CharacterAndFormat.characterAndFormat('c', (TextFormat)NamedTextColor.RED, true);
    public static final CharacterAndFormat LIGHT_PURPLE = CharacterAndFormat.characterAndFormat('d', (TextFormat)NamedTextColor.LIGHT_PURPLE, true);
    public static final CharacterAndFormat YELLOW = CharacterAndFormat.characterAndFormat('e', (TextFormat)NamedTextColor.YELLOW, true);
    public static final CharacterAndFormat WHITE = CharacterAndFormat.characterAndFormat('f', (TextFormat)NamedTextColor.WHITE, true);
    public static final CharacterAndFormat OBFUSCATED = CharacterAndFormat.characterAndFormat('k', (TextFormat)TextDecoration.OBFUSCATED, true);
    public static final CharacterAndFormat BOLD = CharacterAndFormat.characterAndFormat('l', (TextFormat)TextDecoration.BOLD, true);
    public static final CharacterAndFormat STRIKETHROUGH = CharacterAndFormat.characterAndFormat('m', (TextFormat)TextDecoration.STRIKETHROUGH, true);
    public static final CharacterAndFormat UNDERLINED = CharacterAndFormat.characterAndFormat('n', (TextFormat)TextDecoration.UNDERLINED, true);
    public static final CharacterAndFormat ITALIC = CharacterAndFormat.characterAndFormat('o', (TextFormat)TextDecoration.ITALIC, true);
    public static final CharacterAndFormat RESET = CharacterAndFormat.characterAndFormat('r', Reset.INSTANCE, true);

    @NotNull
    public static CharacterAndFormat characterAndFormat(char character, @NotNull TextFormat format) {
        return CharacterAndFormat.characterAndFormat(character, format, false);
    }

    @NotNull
    public static CharacterAndFormat characterAndFormat(char character, @NotNull TextFormat format, boolean caseInsensitive) {
        return new CharacterAndFormatImpl(character, format, caseInsensitive);
    }

    public static @Unmodifiable @NotNull List<CharacterAndFormat> defaults() {
        return CharacterAndFormatImpl.Defaults.DEFAULTS;
    }

    public char character();

    @NotNull
    public TextFormat format();

    public boolean caseInsensitive();

    @NotNull
    default public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"character", (char)this.character()), ExaminableProperty.of((String)"format", (Object)this.format()), ExaminableProperty.of((String)"caseInsensitive", (boolean)this.caseInsensitive()));
    }
}

