/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axminions.minions.miniontype;

import com.artillexstudios.axminions.AxMinionsPlugin;
import com.artillexstudios.axminions.api.integrations.types.PricesIntegration;
import com.artillexstudios.axminions.api.minions.Minion;
import com.artillexstudios.axminions.api.minions.miniontype.MinionType;
import com.artillexstudios.axminions.api.warnings.Warnings;
import com.artillexstudios.axminions.libs.annotations.NotNull;
import com.artillexstudios.axminions.minions.Minion;
import com.artillexstudios.axminions.minions.MinionTicker;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.DoubleChestInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/artillexstudios/axminions/minions/miniontype/SellerMinionType;", "Lcom/artillexstudios/axminions/api/minions/miniontype/MinionType;", "()V", "onToolDirty", "", "minion", "Lcom/artillexstudios/axminions/api/minions/Minion;", "run", "shouldRun", "", "common"})
public final class SellerMinionType
extends MinionType {
    public SellerMinionType() {
        InputStream inputStream = AxMinionsPlugin.Companion.getINSTANCE().getResource("minions/seller.yml");
        Intrinsics.checkNotNull((Object)inputStream);
        super("seller", inputStream);
    }

    @Override
    public boolean shouldRun(@NotNull com.artillexstudios.axminions.api.minions.Minion minion) {
        return MinionTicker.INSTANCE.getTick() % (long)minion.getNextAction() == 0L;
    }

    @Override
    public void onToolDirty(@NotNull com.artillexstudios.axminions.api.minions.Minion minion) {
        Intrinsics.checkNotNull((Object)minion, (String)"null cannot be cast to non-null type com.artillexstudios.axminions.minions.Minion");
        Minion minionImpl = (Minion)minion;
        minionImpl.setRange(this.getDouble("range", minion.getLevel()));
        ItemStack itemStack = minion.getTool();
        double tool = itemStack != null ? (double)itemStack.getEnchantmentLevel(Enchantment.DIG_SPEED) / 10.0 : 0.1;
        double efficiency = 1.0 - (tool > 0.9 ? 0.9 : tool);
        minionImpl.setNextAction(MathKt.roundToInt((double)((double)this.getLong("speed", minion.getLevel()) * efficiency)));
    }

    @Override
    public void run(@NotNull com.artillexstudios.axminions.api.minions.Minion minion) {
        if (minion.getLinkedInventory() != null) {
            Inventory inventory = minion.getLinkedInventory();
            if (!(inventory != null ? inventory.firstEmpty() == -1 : false)) {
                Warnings.remove(minion, Warnings.CONTAINER_FULL);
            }
        }
        if (minion.getLinkedChest() == null) {
            Warnings.NO_CONTAINER.display(minion);
            return;
        }
        Location location = minion.getLinkedChest();
        Intrinsics.checkNotNull((Object)location);
        Material type = location.getBlock().getType();
        if (type == Material.CHEST && !(minion.getLinkedInventory() instanceof DoubleChestInventory)) {
            Location location2 = minion.getLinkedChest();
            Intrinsics.checkNotNull((Object)location2);
            if (this.hasChestOnSide(location2.getBlock())) {
                minion.setLinkedChest(minion.getLinkedChest());
            }
        }
        if (type == Material.CHEST && minion.getLinkedInventory() instanceof DoubleChestInventory) {
            Location location3 = minion.getLinkedChest();
            Intrinsics.checkNotNull((Object)location3);
            if (!this.hasChestOnSide(location3.getBlock())) {
                minion.setLinkedChest(minion.getLinkedChest());
            }
        }
        if (type != Material.CHEST && type != Material.TRAPPED_CHEST && type != Material.BARREL) {
            Warnings.NO_CONTAINER.display(minion);
            minion.setLinkedChest(null);
            return;
        }
        if (minion.getLinkedInventory() == null) {
            Warnings.NO_CONTAINER.display(minion);
            return;
        }
        Warnings.remove(minion, Warnings.NO_CONTAINER);
        if (!minion.canUseTool()) {
            Warnings.NO_TOOL.display(minion);
            return;
        }
        Warnings.remove(minion, Warnings.NO_TOOL);
        if (AxMinionsPlugin.Companion.getIntegrations().getPricesIntegration() == null) {
            return;
        }
        Inventory inventory = minion.getLinkedInventory();
        Intrinsics.checkNotNull((Object)inventory);
        for (ItemStack it : inventory.getContents()) {
            if (it == null || it.getType() == Material.AIR) continue;
            PricesIntegration pricesIntegration = AxMinionsPlugin.Companion.getIntegrations().getPricesIntegration();
            Intrinsics.checkNotNull((Object)pricesIntegration);
            double price = pricesIntegration.getPrice(it);
            if (price <= 0.0) {
                if (!((Boolean)this.getConfig().get("delete-unsellable")).booleanValue()) continue;
                it.setAmount(0);
                continue;
            }
            if (minion.getStorage() + (price *= this.getDouble("multiplier", minion.getLevel())) > this.getDouble("storage", minion.getLevel())) continue;
            minion.setActions(minion.getActionAmount() + (long)it.getAmount());
            Minion.DefaultImpls.damageTool$default(minion, 0, 1, null);
            minion.setStorage(minion.getStorage() + price);
            it.setAmount(0);
        }
    }
}

