/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axminions.minions.miniontype;

import com.artillexstudios.axminions.AxMinionsPlugin;
import com.artillexstudios.axminions.api.minions.miniontype.MinionType;
import com.artillexstudios.axminions.api.utils.LocationUtils;
import com.artillexstudios.axminions.api.utils.MinionUtils;
import com.artillexstudios.axminions.api.warnings.Warnings;
import com.artillexstudios.axminions.libs.annotations.NotNull;
import com.artillexstudios.axminions.minions.Minion;
import com.artillexstudios.axminions.minions.MinionTicker;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.DoubleChestInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\r"}, d2={"Lcom/artillexstudios/axminions/minions/miniontype/LumberMinionType;", "Lcom/artillexstudios/axminions/api/minions/miniontype/MinionType;", "()V", "getSaplingType", "Lorg/bukkit/Material;", "material", "onToolDirty", "", "minion", "Lcom/artillexstudios/axminions/api/minions/Minion;", "run", "shouldRun", "", "common"})
@SourceDebugExtension(value={"SMAP\nLumberMinionType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LumberMinionType.kt\ncom/artillexstudios/axminions/minions/miniontype/LumberMinionType\n+ 2 Collections.kt\ncom/artillexstudios/axminions/api/utils/CollectionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n11#2,4:130\n16#2:136\n1855#3,2:134\n*S KotlinDebug\n*F\n+ 1 LumberMinionType.kt\ncom/artillexstudios/axminions/minions/miniontype/LumberMinionType\n*L\n65#1:130,4\n65#1:136\n66#1:134,2\n*E\n"})
public final class LumberMinionType
extends MinionType {
    public LumberMinionType() {
        InputStream inputStream = AxMinionsPlugin.Companion.getINSTANCE().getResource("minions/lumber.yml");
        Intrinsics.checkNotNull((Object)inputStream);
        super("lumber", inputStream);
    }

    @Override
    public boolean shouldRun(@NotNull com.artillexstudios.axminions.api.minions.Minion minion) {
        return MinionTicker.INSTANCE.getTick() % (long)minion.getNextAction() == 0L;
    }

    @Override
    public void onToolDirty(@NotNull com.artillexstudios.axminions.api.minions.Minion minion) {
        Intrinsics.checkNotNull((Object)minion, (String)"null cannot be cast to non-null type com.artillexstudios.axminions.minions.Minion");
        Minion minionImpl = (Minion)minion;
        minionImpl.setRange(this.getDouble("range", minion.getLevel()));
        ItemStack itemStack = minion.getTool();
        double tool = itemStack != null ? (double)itemStack.getEnchantmentLevel(Enchantment.DIG_SPEED) / 10.0 : 0.1;
        double efficiency = 1.0 - (tool > 0.9 ? 0.9 : tool);
        minionImpl.setNextAction(MathKt.roundToInt((double)((double)this.getLong("speed", minion.getLevel()) * efficiency)));
    }

    @Override
    public void run(@NotNull com.artillexstudios.axminions.api.minions.Minion minion) {
        int n;
        IntRange indices$iv;
        int i$iv;
        if (minion.getLinkedInventory() != null) {
            Inventory inventory = minion.getLinkedInventory();
            if (!(inventory != null ? inventory.firstEmpty() == -1 : false)) {
                Warnings.remove(minion, Warnings.CONTAINER_FULL);
            }
        }
        if (minion.getLinkedChest() != null) {
            Location location = minion.getLinkedChest();
            Intrinsics.checkNotNull((Object)location);
            Material type = location.getBlock().getType();
            if (type == Material.CHEST && !(minion.getLinkedInventory() instanceof DoubleChestInventory)) {
                Location location2 = minion.getLinkedChest();
                Intrinsics.checkNotNull((Object)location2);
                if (this.hasChestOnSide(location2.getBlock())) {
                    minion.setLinkedChest(minion.getLinkedChest());
                }
            }
            if (type == Material.CHEST && minion.getLinkedInventory() instanceof DoubleChestInventory) {
                Location location3 = minion.getLinkedChest();
                Intrinsics.checkNotNull((Object)location3);
                if (!this.hasChestOnSide(location3.getBlock())) {
                    minion.setLinkedChest(minion.getLinkedChest());
                }
            }
            if (type != Material.CHEST && type != Material.TRAPPED_CHEST && type != Material.BARREL) {
                minion.setLinkedChest(null);
            }
        }
        if (!minion.canUseTool()) {
            Warnings.NO_TOOL.display(minion);
            return;
        }
        Inventory inventory = minion.getLinkedInventory();
        boolean bl = inventory != null ? inventory.firstEmpty() == -1 : false;
        if (bl) {
            Warnings.CONTAINER_FULL.display(minion);
            return;
        }
        Warnings.remove(minion, Warnings.NO_TOOL);
        ArrayList loot = new ArrayList();
        List $this$fastFor$iv = LocationUtils.getAllBlocksInRadius(minion.getLocation(), minion.getRange(), false);
        boolean $i$f$fastFor = false;
        if (!$this$fastFor$iv.isEmpty() && (i$iv = (indices$iv = CollectionsKt.getIndices((Collection)$this$fastFor$iv)).getFirst()) <= (n = indices$iv.getLast())) {
            while (true) {
                Location location = (Location)$this$fastFor$iv.get(i$iv);
                boolean bl2 = false;
                Iterable $this$forEach$iv = MinionUtils.getTree(location.getBlock());
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Block it = (Block)element$iv;
                    boolean bl3 = false;
                    Material down = it.getRelative(BlockFace.DOWN).getType();
                    loot.addAll(it.getDrops(minion.getTool()));
                    if (down == Material.DIRT || down == Material.GRASS_BLOCK || down == Material.COARSE_DIRT || down == Material.ROOTED_DIRT || down == Material.DIRT_PATH || down == Material.MUD || down == Material.MUDDY_MANGROVE_ROOTS || down == Material.PODZOL) {
                        it.setType(this.getSaplingType(it.getType()));
                        continue;
                    }
                    it.setType(Material.AIR);
                }
                if (i$iv == n) break;
                ++i$iv;
            }
        }
        int lootSize = loot.size();
        minion.damageTool(lootSize);
        minion.setActions(minion.getActionAmount() + (long)lootSize);
        minion.addToContainerOrDrop(loot);
    }

    private final Material getSaplingType(Material material) {
        return switch (material.name()) {
            case "DARK_OAK_LOG" -> Material.DARK_OAK_SAPLING;
            case "BIRCH_LOG" -> Material.BIRCH_SAPLING;
            case "ACACIA_LOG" -> Material.ACACIA_SAPLING;
            case "JUNGLE_LOG" -> Material.JUNGLE_SAPLING;
            case "SPRUCE_LOG" -> Material.SPRUCE_SAPLING;
            case "MANGROVE_LOG" -> Material.MANGROVE_PROPAGULE;
            case "CHERRY_LOG" -> Material.CHERRY_SAPLING;
            case "PALE_OAK_LOG" -> Material.valueOf((String)"PALE_OAK_SAPLING");
            case "CRIMSON_STEM" -> Material.valueOf((String)"CRIMSON_FUNGUS");
            case "WARPED_STEM" -> Material.valueOf((String)"WARPED_FUNGUS");
            default -> Material.OAK_SAPLING;
        };
    }
}

