/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axminions.minions.miniontype;

import com.artillexstudios.axminions.AxMinionsPlugin;
import com.artillexstudios.axminions.api.events.PreFisherMinionFishEvent;
import com.artillexstudios.axminions.api.minions.Minion;
import com.artillexstudios.axminions.api.minions.miniontype.MinionType;
import com.artillexstudios.axminions.api.utils.LocationUtils;
import com.artillexstudios.axminions.api.warnings.Warnings;
import com.artillexstudios.axminions.libs.annotations.NotNull;
import com.artillexstudios.axminions.minions.Minion;
import com.artillexstudios.axminions.minions.MinionTicker;
import com.artillexstudios.axminions.nms.NMSHandler;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.Event;
import org.bukkit.inventory.DoubleChestInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/artillexstudios/axminions/minions/miniontype/FisherMinionType;", "Lcom/artillexstudios/axminions/api/minions/miniontype/MinionType;", "()V", "onToolDirty", "", "minion", "Lcom/artillexstudios/axminions/api/minions/Minion;", "run", "shouldRun", "", "common"})
@SourceDebugExtension(value={"SMAP\nFisherMinionType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FisherMinionType.kt\ncom/artillexstudios/axminions/minions/miniontype/FisherMinionType\n+ 2 Collections.kt\ncom/artillexstudios/axminions/api/utils/CollectionsKt\n*L\n1#1,101:1\n11#2,6:102\n*S KotlinDebug\n*F\n+ 1 FisherMinionType.kt\ncom/artillexstudios/axminions/minions/miniontype/FisherMinionType\n*L\n61#1:102,6\n*E\n"})
public final class FisherMinionType
extends MinionType {
    public FisherMinionType() {
        InputStream inputStream = AxMinionsPlugin.Companion.getINSTANCE().getResource("minions/fisher.yml");
        Intrinsics.checkNotNull((Object)inputStream);
        super("fisher", inputStream);
    }

    @Override
    public boolean shouldRun(@NotNull com.artillexstudios.axminions.api.minions.Minion minion) {
        return MinionTicker.INSTANCE.getTick() % (long)minion.getNextAction() == 0L;
    }

    @Override
    public void onToolDirty(@NotNull com.artillexstudios.axminions.api.minions.Minion minion) {
        Intrinsics.checkNotNull((Object)minion, (String)"null cannot be cast to non-null type com.artillexstudios.axminions.minions.Minion");
        Minion minionImpl = (Minion)minion;
        minionImpl.setRange(this.getDouble("range", minion.getLevel()));
        ItemStack itemStack = minion.getTool();
        double tool = itemStack != null ? (double)itemStack.getEnchantmentLevel(Enchantment.LURE) / 10.0 : 0.1;
        double efficiency = 1.0 - (tool > 0.9 ? 0.9 : tool);
        minionImpl.setNextAction(MathKt.roundToInt((double)((double)this.getLong("speed", minion.getLevel()) * efficiency)));
    }

    @Override
    public void run(@NotNull com.artillexstudios.axminions.api.minions.Minion minion) {
        int n;
        IntRange indices$iv;
        int i$iv;
        if (minion.getLinkedInventory() != null) {
            Inventory inventory = minion.getLinkedInventory();
            if (!(inventory != null ? inventory.firstEmpty() == -1 : false)) {
                Warnings.remove(minion, Warnings.CONTAINER_FULL);
            }
        }
        if (minion.getLinkedChest() != null) {
            Location location = minion.getLinkedChest();
            Intrinsics.checkNotNull((Object)location);
            Material type = location.getBlock().getType();
            if (type == Material.CHEST && !(minion.getLinkedInventory() instanceof DoubleChestInventory)) {
                Location location2 = minion.getLinkedChest();
                Intrinsics.checkNotNull((Object)location2);
                if (this.hasChestOnSide(location2.getBlock())) {
                    minion.setLinkedChest(minion.getLinkedChest());
                }
            }
            if (type == Material.CHEST && minion.getLinkedInventory() instanceof DoubleChestInventory) {
                Location location3 = minion.getLinkedChest();
                Intrinsics.checkNotNull((Object)location3);
                if (!this.hasChestOnSide(location3.getBlock())) {
                    minion.setLinkedChest(minion.getLinkedChest());
                }
            }
            if (type != Material.CHEST && type != Material.TRAPPED_CHEST && type != Material.BARREL) {
                minion.setLinkedChest(null);
            }
        }
        Inventory inventory = minion.getLinkedInventory();
        boolean bl = inventory != null ? inventory.firstEmpty() == -1 : false;
        if (bl) {
            Warnings.CONTAINER_FULL.display(minion);
            return;
        }
        Location waterLocation = null;
        FisherMinionType $this$run_u24lambda_u241 = this;
        boolean bl2 = false;
        List $this$fastFor$iv = LocationUtils.getAllBlocksInRadius(minion.getLocation(), 2.0, false);
        boolean $i$f$fastFor = false;
        if (!$this$fastFor$iv.isEmpty() && (i$iv = (indices$iv = CollectionsKt.getIndices((Collection)$this$fastFor$iv)).getFirst()) <= (n = indices$iv.getLast())) {
            while (true) {
                Location it = (Location)$this$fastFor$iv.get(i$iv);
                boolean bl3 = false;
                if (it.getBlock().getType() == Material.WATER) {
                    waterLocation = it;
                    break;
                }
                if (i$iv == n) break;
                ++i$iv;
            }
        }
        if (waterLocation == null) {
            Warnings.NO_WATER_NEARBY.display(minion);
            return;
        }
        Warnings.remove(minion, Warnings.NO_WATER_NEARBY);
        if (!minion.canUseTool()) {
            Warnings.NO_TOOL.display(minion);
            return;
        }
        Warnings.remove(minion, Warnings.NO_TOOL);
        List<ItemStack> loot = NMSHandler.Companion.get().generateRandomFishingLoot(minion, waterLocation);
        PreFisherMinionFishEvent preFishEvent = new PreFisherMinionFishEvent(minion, loot);
        Bukkit.getPluginManager().callEvent((Event)preFishEvent);
        if (preFishEvent.isCancelled()) {
            return;
        }
        if (!Intrinsics.areEqual(preFishEvent.getItem(), loot)) {
            loot = preFishEvent.getItem();
        }
        int xp = ThreadLocalRandom.current().nextInt(6) + 1;
        minion.addToContainerOrDrop((Iterable<? extends ItemStack>)loot);
        double coerced = RangesKt.coerceIn((double)(minion.getStorage() + (double)xp), (double)0.0, (double)minion.getType().getLong("storage", minion.getLevel()));
        minion.setStorage(coerced);
        minion.setActions(minion.getActionAmount() + 1L);
        Minion.DefaultImpls.damageTool$default(minion, 0, 1, null);
    }
}

