/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axminions.minions.miniontype;

import com.artillexstudios.axminions.AxMinionsPlugin;
import com.artillexstudios.axminions.api.minions.miniontype.MinionType;
import com.artillexstudios.axminions.api.warnings.Warnings;
import com.artillexstudios.axminions.libs.annotations.NotNull;
import com.artillexstudios.axminions.minions.Minion;
import com.artillexstudios.axminions.minions.MinionTicker;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.inventory.DoubleChestInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\"\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bH\u0002J4\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\r2\"\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bH\u0002J<\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\"\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bH\u0002J<\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\r2\"\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bH\u0002J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/artillexstudios/axminions/minions/miniontype/CrafterMinionType;", "Lcom/artillexstudios/axminions/api/minions/miniontype/MinionType;", "()V", "canCraftShaped", "", "recipe", "Lorg/bukkit/inventory/ShapedRecipe;", "contents", "Ljava/util/HashMap;", "Lorg/bukkit/inventory/ItemStack;", "", "Lkotlin/collections/HashMap;", "canCraftShapeless", "Lorg/bukkit/inventory/ShapelessRecipe;", "doCraftShaped", "", "inventory", "Lorg/bukkit/inventory/Inventory;", "doCraftShapeless", "onToolDirty", "minion", "Lcom/artillexstudios/axminions/api/minions/Minion;", "run", "shouldRun", "common"})
public final class CrafterMinionType
extends MinionType {
    public CrafterMinionType() {
        InputStream inputStream = AxMinionsPlugin.Companion.getINSTANCE().getResource("minions/crafter.yml");
        Intrinsics.checkNotNull((Object)inputStream);
        super("crafter", inputStream);
    }

    @Override
    public boolean shouldRun(@NotNull com.artillexstudios.axminions.api.minions.Minion minion) {
        return MinionTicker.INSTANCE.getTick() % (long)minion.getNextAction() == 0L;
    }

    @Override
    public void onToolDirty(@NotNull com.artillexstudios.axminions.api.minions.Minion minion) {
        Intrinsics.checkNotNull((Object)minion, (String)"null cannot be cast to non-null type com.artillexstudios.axminions.minions.Minion");
        Minion minionImpl = (Minion)minion;
        minionImpl.setRange(1.0);
        minionImpl.setNextAction((int)this.getLong("speed", minion.getLevel()));
    }

    @Override
    public void run(@NotNull com.artillexstudios.axminions.api.minions.Minion minion) {
        ItemStack tool;
        if (minion.getLinkedChest() == null) {
            Warnings.NO_CONTAINER.display(minion);
            return;
        }
        Location location = minion.getLinkedChest();
        Intrinsics.checkNotNull((Object)location);
        Material type = location.getBlock().getType();
        if (type == Material.CHEST && !(minion.getLinkedInventory() instanceof DoubleChestInventory)) {
            Location location2 = minion.getLinkedChest();
            Intrinsics.checkNotNull((Object)location2);
            if (this.hasChestOnSide(location2.getBlock())) {
                minion.setLinkedChest(minion.getLinkedChest());
            }
        }
        if (type == Material.CHEST && minion.getLinkedInventory() instanceof DoubleChestInventory) {
            Location location3 = minion.getLinkedChest();
            Intrinsics.checkNotNull((Object)location3);
            if (!this.hasChestOnSide(location3.getBlock())) {
                minion.setLinkedChest(minion.getLinkedChest());
            }
        }
        if (type != Material.CHEST && type != Material.TRAPPED_CHEST && type != Material.BARREL) {
            Warnings.NO_CONTAINER.display(minion);
            minion.setLinkedChest(null);
            return;
        }
        if (minion.getLinkedInventory() == null) {
            return;
        }
        Warnings.remove(minion, Warnings.NO_CONTAINER);
        if (!minion.canUseTool()) {
            Warnings.NO_TOOL.display(minion);
            return;
        }
        Warnings.remove(minion, Warnings.NO_TOOL);
        ItemStack itemStack = tool = minion.getTool();
        if (itemStack == null) {
            return;
        }
        List recipes = Bukkit.getRecipesFor((ItemStack)itemStack);
        ArrayList<Recipe> shaped = new ArrayList<Recipe>();
        ArrayList<Recipe> shapeless = new ArrayList<Recipe>();
        for (Recipe recipe : recipes) {
            if (recipe instanceof ShapedRecipe) {
                shaped.add(recipe);
                continue;
            }
            if (!(recipe instanceof ShapelessRecipe)) continue;
            shapeless.add(recipe);
        }
        Inventory inventory = minion.getLinkedInventory();
        if (inventory == null) {
            return;
        }
        Inventory inv = inventory;
        ItemStack[] items = inv.getContents();
        HashMap<ItemStack, Integer> contents = new HashMap<ItemStack, Integer>();
        block1: for (ItemStack item : items) {
            if (item == null || item.getType().isAir()) continue;
            if (contents.isEmpty()) {
                ((Map)contents).put(item, item.getAmount());
                continue;
            }
            for (Map.Entry<ItemStack, Integer> next : contents.entrySet()) {
                if (!item.isSimilar(next.getKey())) continue;
                next.setValue(((Number)next.getValue()).intValue() + item.getAmount());
                continue block1;
            }
            ((Map)contents).put(item, item.getAmount());
        }
        Iterator recipeIterator = shapeless.iterator();
        while (recipeIterator.hasNext()) {
            ShapelessRecipe recipe = (ShapelessRecipe)recipeIterator.next();
            if (!this.canCraftShapeless(recipe, contents)) {
                recipeIterator.remove();
                continue;
            }
            this.doCraftShapeless(inv, recipe, contents);
            minion.setActions(minion.getActionAmount() + 1L);
            recipeIterator = shapeless.iterator();
        }
        Iterator shapedIterator = shaped.iterator();
        while (shapedIterator.hasNext()) {
            ShapedRecipe recipe = (ShapedRecipe)shapedIterator.next();
            if (!this.canCraftShaped(recipe, contents)) {
                shapedIterator.remove();
                continue;
            }
            this.doCraftShaped(inv, recipe, contents);
            minion.setActions(minion.getActionAmount() + 1L);
            shapedIterator = shaped.iterator();
        }
    }

    private final boolean canCraftShapeless(ShapelessRecipe recipe, HashMap<ItemStack, Integer> contents) {
        Object object = contents.clone();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.HashMap<org.bukkit.inventory.ItemStack, kotlin.Int>{ kotlin.collections.TypeAliasesKt.HashMap<org.bukkit.inventory.ItemStack, kotlin.Int> }");
        HashMap clone = (HashMap)object;
        for (RecipeChoice recipeChoice : recipe.getChoiceList()) {
            if (recipeChoice == null || recipeChoice.getItemStack() == null) continue;
            int amount = 0;
            Iterator iterator = clone.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                if (!recipeChoice.test((ItemStack)next.getKey())) continue;
                amount += ((Number)next.getValue()).intValue();
                int amt = ((Number)next.getValue()).intValue() - recipeChoice.getItemStack().getAmount();
                if (amt == 0) {
                    iterator.remove();
                    continue;
                }
                if (amt > 0) {
                    next.setValue(amt);
                    continue;
                }
                return false;
            }
            if (amount >= recipeChoice.getItemStack().getAmount()) continue;
            return false;
        }
        return true;
    }

    private final boolean canCraftShaped(ShapedRecipe recipe, HashMap<ItemStack, Integer> contents) {
        Object object = contents.clone();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.HashMap<org.bukkit.inventory.ItemStack, kotlin.Int>{ kotlin.collections.TypeAliasesKt.HashMap<org.bukkit.inventory.ItemStack, kotlin.Int> }");
        HashMap clone = (HashMap)object;
        for (Map.Entry recipeChoice : recipe.getChoiceMap().entrySet()) {
            if (recipeChoice.getValue() == null || ((RecipeChoice)recipeChoice.getValue()).getItemStack() == null) continue;
            int amount = 0;
            Iterator iterator = clone.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                if (!((RecipeChoice)recipeChoice.getValue()).test((ItemStack)next.getKey())) continue;
                amount += ((Number)next.getValue()).intValue();
                int amt = ((Number)next.getValue()).intValue() - ((RecipeChoice)recipeChoice.getValue()).getItemStack().getAmount();
                if (amt == 0) {
                    iterator.remove();
                    continue;
                }
                if (amt > 0) {
                    next.setValue(amt);
                    continue;
                }
                return false;
            }
            if (amount >= ((RecipeChoice)recipeChoice.getValue()).getItemStack().getAmount()) continue;
            return false;
        }
        return true;
    }

    private final void doCraftShapeless(Inventory inventory, ShapelessRecipe recipe, HashMap<ItemStack, Integer> contents) {
        ItemStack[] recipeChoice2;
        block0: for (ItemStack[] recipeChoice2 : recipe.getChoiceList()) {
            if (recipeChoice2 == null || recipeChoice2.getItemStack() == null) continue;
            for (ItemStack content : inventory.getContents()) {
                if (content == null || !recipeChoice2.test(content)) continue;
                content.setAmount(content.getAmount() - recipeChoice2.getItemStack().getAmount());
                break;
            }
            Iterator<Map.Entry<ItemStack, Integer>> iterator = contents.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ItemStack, Integer> next = iterator.next();
                if (!recipeChoice2.test(next.getKey())) continue;
                int amount = ((Number)next.getValue()).intValue() - recipeChoice2.getItemStack().getAmount();
                if (amount <= 0) {
                    iterator.remove();
                    continue block0;
                }
                next.setValue(amount);
                continue block0;
            }
        }
        ItemStack result = recipe.getResult().clone();
        recipeChoice2 = new ItemStack[]{result};
        inventory.addItem(recipeChoice2);
        for (Map.Entry<ItemStack, Integer> next : contents.entrySet()) {
            if (!result.isSimilar(next.getKey())) continue;
            next.setValue(((Number)next.getValue()).intValue() + result.getAmount());
            return;
        }
        ((Map)contents).put(result, result.getAmount());
    }

    private final void doCraftShaped(Inventory inventory, ShapedRecipe recipe, HashMap<ItemStack, Integer> contents) {
        block0: for (Map.Entry entry : recipe.getChoiceMap().entrySet()) {
            if (entry.getValue() == null || ((RecipeChoice)entry.getValue()).getItemStack() == null) continue;
            for (ItemStack content : inventory.getContents()) {
                if (content == null || !((RecipeChoice)entry.getValue()).test(content)) continue;
                content.setAmount(content.getAmount() - ((RecipeChoice)entry.getValue()).getItemStack().getAmount());
                break;
            }
            Iterator<Map.Entry<ItemStack, Integer>> iterator = contents.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ItemStack, Integer> next = iterator.next();
                if (!((RecipeChoice)entry.getValue()).test(next.getKey())) continue;
                int amount = ((Number)next.getValue()).intValue() - ((RecipeChoice)entry.getValue()).getItemStack().getAmount();
                if (amount <= 0) {
                    iterator.remove();
                    continue block0;
                }
                next.setValue(amount);
                continue block0;
            }
        }
        ItemStack result = recipe.getResult().clone();
        ItemStack[] itemStackArray = new ItemStack[]{result};
        inventory.addItem(itemStackArray);
        for (Map.Entry<ItemStack, Integer> next : contents.entrySet()) {
            if (!result.isSimilar(next.getKey())) continue;
            next.setValue(((Number)next.getValue()).intValue() + result.getAmount());
            return;
        }
        ((Map)contents).put(result, result.getAmount());
    }
}

