/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axminions.minions.miniontype;

import com.artillexstudios.axminions.AxMinionsPlugin;
import com.artillexstudios.axminions.api.AxMinionsAPI;
import com.artillexstudios.axminions.api.minions.Minion;
import com.artillexstudios.axminions.api.minions.miniontype.MinionType;
import com.artillexstudios.axminions.api.warnings.Warnings;
import com.artillexstudios.axminions.libs.annotations.NotNull;
import com.artillexstudios.axminions.minions.Minion;
import com.artillexstudios.axminions.minions.MinionTicker;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Item;
import org.bukkit.inventory.DoubleChestInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/artillexstudios/axminions/minions/miniontype/CollectorMinionType;", "Lcom/artillexstudios/axminions/api/minions/miniontype/MinionType;", "()V", "onToolDirty", "", "minion", "Lcom/artillexstudios/axminions/api/minions/Minion;", "run", "shouldRun", "", "common"})
@SourceDebugExtension(value={"SMAP\nCollectorMinionType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CollectorMinionType.kt\ncom/artillexstudios/axminions/minions/miniontype/CollectorMinionType\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Collections.kt\ncom/artillexstudios/axminions/api/utils/CollectionsKt\n*L\n1#1,93:1\n800#2,11:94\n11#3,6:105\n*S KotlinDebug\n*F\n+ 1 CollectorMinionType.kt\ncom/artillexstudios/axminions/minions/miniontype/CollectorMinionType\n*L\n71#1:94,11\n71#1:105,6\n*E\n"})
public final class CollectorMinionType
extends MinionType {
    public CollectorMinionType() {
        InputStream inputStream = AxMinionsPlugin.Companion.getINSTANCE().getResource("minions/collector.yml");
        Intrinsics.checkNotNull((Object)inputStream);
        super("collector", inputStream);
    }

    @Override
    public boolean shouldRun(@NotNull com.artillexstudios.axminions.api.minions.Minion minion) {
        return MinionTicker.INSTANCE.getTick() % (long)minion.getNextAction() == 0L;
    }

    @Override
    public void onToolDirty(@NotNull com.artillexstudios.axminions.api.minions.Minion minion) {
        Intrinsics.checkNotNull((Object)minion, (String)"null cannot be cast to non-null type com.artillexstudios.axminions.minions.Minion");
        Minion minionImpl = (Minion)minion;
        minionImpl.setRange(this.getDouble("range", minion.getLevel()));
        ItemStack itemStack = minion.getTool();
        double tool = itemStack != null ? (double)itemStack.getEnchantmentLevel(Enchantment.DIG_SPEED) / 10.0 : 0.1;
        double efficiency = 1.0 - (tool > 0.9 ? 0.9 : tool);
        minionImpl.setNextAction(MathKt.roundToInt((double)((double)this.getLong("speed", minion.getLevel()) * efficiency)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run(@NotNull com.artillexstudios.axminions.api.minions.Minion minion) {
        Collection entities;
        if (minion.getLinkedInventory() != null) {
            Inventory inventory = minion.getLinkedInventory();
            if (!(inventory != null ? inventory.firstEmpty() == -1 : false)) {
                Warnings.remove(minion, Warnings.CONTAINER_FULL);
            }
        }
        if (minion.getLinkedChest() == null) {
            Warnings.NO_CONTAINER.display(minion);
            return;
        }
        Location location = minion.getLinkedChest();
        Intrinsics.checkNotNull((Object)location);
        Material type = location.getBlock().getType();
        if (type == Material.CHEST && !(minion.getLinkedInventory() instanceof DoubleChestInventory)) {
            Location location2 = minion.getLinkedChest();
            Intrinsics.checkNotNull((Object)location2);
            if (this.hasChestOnSide(location2.getBlock())) {
                minion.setLinkedChest(minion.getLinkedChest());
            }
        }
        if (type == Material.CHEST && minion.getLinkedInventory() instanceof DoubleChestInventory) {
            Location location3 = minion.getLinkedChest();
            Intrinsics.checkNotNull((Object)location3);
            if (!this.hasChestOnSide(location3.getBlock())) {
                minion.setLinkedChest(minion.getLinkedChest());
            }
        }
        if (type != Material.CHEST && type != Material.TRAPPED_CHEST && type != Material.BARREL) {
            Warnings.NO_CONTAINER.display(minion);
            minion.setLinkedChest(null);
            return;
        }
        Warnings.remove(minion, Warnings.NO_CONTAINER);
        if (!minion.canUseTool()) {
            Warnings.NO_TOOL.display(minion);
            return;
        }
        Warnings.remove(minion, Warnings.NO_TOOL);
        World world = minion.getLocation().getWorld();
        Collection collection = entities = world != null ? world.getNearbyEntities(minion.getLocation(), minion.getRange(), minion.getRange(), minion.getRange()) : null;
        if (collection != null) {
            int n;
            IntRange indices$iv;
            int i$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = collection;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof Item)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List $this$fastFor$iv = (List)destination$iv$iv;
            boolean $i$f$fastFor = false;
            if (!$this$fastFor$iv.isEmpty() && (i$iv = (indices$iv = CollectionsKt.getIndices((Collection)$this$fastFor$iv)).getFirst()) <= (n = indices$iv.getLast())) {
                while (true) {
                    Item item = (Item)$this$fastFor$iv.get(i$iv);
                    boolean bl = false;
                    Inventory inventory = minion.getLinkedInventory();
                    boolean bl2 = inventory != null ? inventory.firstEmpty() == -1 : false;
                    if (bl2) {
                        Warnings.CONTAINER_FULL.display(minion);
                        return;
                    }
                    long amount = AxMinionsPlugin.Companion.getIntegrations().getStackerIntegration().getStackSize(item);
                    ItemStack stack = item.getItemStack().clone();
                    stack.setAmount((int)amount);
                    if (minion.addWithRemaining(stack) != null) {
                        HashMap<Integer, ItemStack> map;
                        if (map.isEmpty() || stack.getAmount() <= 0) {
                            item.remove();
                        } else {
                            AxMinionsAPI.Companion.getINSTANCE().getIntegrations().getStackerIntegration().setStackSize(item, stack.getAmount());
                        }
                        minion.setActions(minion.getActionAmount() + amount);
                        Minion.DefaultImpls.damageTool$default(minion, 0, 1, null);
                    }
                    if (i$iv == n) break;
                    ++i$iv;
                }
            }
        }
    }
}

