/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axminions.minions;

import com.artillexstudios.axminions.api.minions.Minion;
import com.artillexstudios.axminions.api.minions.utils.ChunkPos;
import com.artillexstudios.axminions.libs.annotations.NotNull;
import com.artillexstudios.axminions.libs.axapi.scheduler.ScheduledTask;
import com.artillexstudios.axminions.libs.axapi.scheduler.Scheduler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\r\u001a\u00020\u000e2\"\u0010\u0007\u001a\u001e\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\n\u0012\u0004\u0012\u00020\u000e0\u000fH\u0080\b\u00a2\u0006\u0002\b\u0010J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0013J\u000e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0013J\u000e\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R$\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001d"}, d2={"Lcom/artillexstudios/axminions/minions/Minions;", "", "()V", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getLock$common", "()Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "minions", "Ljava/util/ArrayList;", "Lcom/artillexstudios/axminions/api/minions/utils/ChunkPos;", "Lkotlin/collections/ArrayList;", "getMinions$common", "()Ljava/util/ArrayList;", "get", "", "Lkotlin/Function1;", "get$common", "getMinions", "", "Lcom/artillexstudios/axminions/api/minions/Minion;", "isTicking", "", "chunk", "Lorg/bukkit/Chunk;", "load", "minion", "remove", "startTicking", "stopTicking", "common"})
@SourceDebugExtension(value={"SMAP\nMinions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Minions.kt\ncom/artillexstudios/axminions/minions/Minions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,182:1\n1855#2,2:183\n1855#2,2:185\n1855#2,2:187\n1855#2,2:189\n1855#2,2:191\n1855#2,2:193\n1855#2,2:195\n1855#2,2:197\n*S KotlinDebug\n*F\n+ 1 Minions.kt\ncom/artillexstudios/axminions/minions/Minions\n*L\n35#1:183,2\n51#1:185,2\n78#1:187,2\n115#1:189,2\n169#1:191,2\n25#1:193,2\n68#1:195,2\n97#1:197,2\n*E\n"})
public final class Minions {
    @NotNull
    public static final Minions INSTANCE = new Minions();
    @NotNull
    private static final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    @NotNull
    private static final ArrayList<ChunkPos> minions = new ArrayList();

    private Minions() {
    }

    @NotNull
    public final ReentrantReadWriteLock getLock$common() {
        return lock;
    }

    @NotNull
    public final ArrayList<ChunkPos> getMinions$common() {
        return minions;
    }

    public final void startTicking(@NotNull Chunk chunk) {
        int chunkX = chunk.getX();
        int chunkZ = chunk.getZ();
        World world = chunk.getWorld();
        if (!Bukkit.isPrimaryThread()) {
            Scheduler.get().run(arg_0 -> Minions.startTicking$lambda$2(world, chunkX, chunkZ, arg_0));
        } else {
            Minions $this$startTicking_u24lambda_u244 = this;
            boolean bl = false;
            Iterable $this$forEach$iv = minions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ChunkPos it = (ChunkPos)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)world.getUID(), (Object)it.getWorldUUID()) || it.getX() != chunkX || it.getZ() != chunkZ) continue;
                it.setTicking(true);
                break;
            }
        }
    }

    public final boolean isTicking(@NotNull Chunk chunk) {
        int chunkX = chunk.getX();
        int chunkZ = chunk.getZ();
        World world = chunk.getWorld();
        Iterable $this$forEach$iv = minions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChunkPos it = (ChunkPos)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)world.getUID(), (Object)it.getWorldUUID()) || it.getX() != chunkX || it.getZ() != chunkZ) continue;
            return it.ticking;
        }
        return false;
    }

    public final void stopTicking(@NotNull Chunk chunk) {
        int chunkX = chunk.getX();
        int chunkZ = chunk.getZ();
        World world = chunk.getWorld();
        if (!Bukkit.isPrimaryThread()) {
            Scheduler.get().run(arg_0 -> Minions.stopTicking$lambda$8(world, chunkX, chunkZ, arg_0));
        } else {
            Minions $this$stopTicking_u24lambda_u2410 = this;
            boolean bl = false;
            Iterable $this$forEach$iv = minions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ChunkPos it = (ChunkPos)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)world.getUID(), (Object)it.getWorldUUID()) || it.getX() != chunkX || it.getZ() != chunkZ) continue;
                it.setTicking(false);
                break;
            }
        }
    }

    public final void load(@NotNull Minion minion) {
        int chunkX = minion.getLocation().getBlockX() >> 4;
        int chunkZ = minion.getLocation().getBlockZ() >> 4;
        World world = minion.getLocation().getWorld();
        if (world == null) {
            return;
        }
        World world2 = world;
        if (!Bukkit.isPrimaryThread()) {
            Scheduler.get().run(arg_0 -> Minions.load$lambda$13(world2, chunkX, chunkZ, minion, arg_0));
        } else {
            ChunkPos pos = null;
            Minions $this$load_u24lambda_u2415 = this;
            boolean bl = false;
            Iterable $this$forEach$iv = minions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ChunkPos it = (ChunkPos)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)world2.getUID(), (Object)it.getWorldUUID()) || it.getX() != chunkX || it.getZ() != chunkZ) continue;
                pos = it;
                break;
            }
            if (pos == null) {
                pos = new ChunkPos(world2, chunkX, chunkZ, false);
                minions.add(pos);
            }
            pos.addMinion(minion);
        }
    }

    public final void remove(@NotNull Minion minion) {
        int chunkX = minion.getLocation().getBlockX() >> 4;
        int chunkZ = minion.getLocation().getBlockZ() >> 4;
        World world = minion.getLocation().getWorld();
        if (world == null) {
            return;
        }
        World world2 = world;
        if (!Bukkit.isPrimaryThread()) {
            Scheduler.get().run(arg_0 -> Minions.remove$lambda$16(world2, chunkX, chunkZ, minion, arg_0));
        } else {
            Iterator<ChunkPos> iterator = minions.iterator();
            while (iterator.hasNext()) {
                ChunkPos next = iterator.next();
                if (!Intrinsics.areEqual((Object)world2.getUID(), (Object)next.getWorldUUID()) || next.getX() != chunkX || next.getZ() != chunkZ) continue;
                if (!next.removeMinion(minion)) break;
                iterator.remove();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Minion> getMinions() {
        List list = new ArrayList();
        ReentrantReadWriteLock.ReadLock readLock = lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            Iterable $this$forEach$iv = minions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ChunkPos it = (ChunkPos)element$iv;
                boolean bl2 = false;
                list.addAll((Collection)it.getMinions());
            }
            List<Minion> list2 = Collections.unmodifiableList(list);
            return list2;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void get$common(@NotNull Function1<? super ArrayList<ChunkPos>, Unit> minions) {
        boolean $i$f$get$common = false;
        ReentrantReadWriteLock.ReadLock readLock = this.getLock$common().readLock();
        readLock.lock();
        try {
            boolean bl = false;
            minions.invoke(this.getMinions$common());
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            readLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
    }

    private static final void startTicking$lambda$2(World $world, int $chunkX, int $chunkZ, ScheduledTask a) {
        Minions $this$startTicking_u24lambda_u242_u24lambda_u241 = INSTANCE;
        boolean bl = false;
        Iterable $this$forEach$iv = minions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChunkPos it = (ChunkPos)element$iv;
            boolean bl2 = false;
            if (!Intrinsics.areEqual((Object)$world.getUID(), (Object)it.getWorldUUID()) || it.getX() != $chunkX || it.getZ() != $chunkZ) continue;
            it.setTicking(true);
            break;
        }
    }

    private static final void stopTicking$lambda$8(World $world, int $chunkX, int $chunkZ, ScheduledTask a) {
        Minions $this$stopTicking_u24lambda_u248_u24lambda_u247 = INSTANCE;
        boolean bl = false;
        Iterable $this$forEach$iv = minions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChunkPos it = (ChunkPos)element$iv;
            boolean bl2 = false;
            if (!Intrinsics.areEqual((Object)$world.getUID(), (Object)it.getWorldUUID()) || it.getX() != $chunkX || it.getZ() != $chunkZ) continue;
            it.setTicking(false);
            break;
        }
    }

    private static final void load$lambda$13(World $world, int $chunkX, int $chunkZ, Minion $minion, ScheduledTask a) {
        ChunkPos pos = null;
        Minions $this$load_u24lambda_u2413_u24lambda_u2412 = INSTANCE;
        boolean bl = false;
        Iterable $this$forEach$iv = minions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChunkPos it = (ChunkPos)element$iv;
            boolean bl2 = false;
            if (!Intrinsics.areEqual((Object)$world.getUID(), (Object)it.getWorldUUID()) || it.getX() != $chunkX || it.getZ() != $chunkZ) continue;
            pos = it;
            break;
        }
        if (pos == null) {
            pos = new ChunkPos($world, $chunkX, $chunkZ, false);
            minions.add(pos);
        }
        pos.addMinion($minion);
    }

    private static final void remove$lambda$16(World $world, int $chunkX, int $chunkZ, Minion $minion, ScheduledTask a) {
        Iterator<ChunkPos> iterator = minions.iterator();
        while (iterator.hasNext()) {
            ChunkPos next = iterator.next();
            if (!Intrinsics.areEqual((Object)$world.getUID(), (Object)next.getWorldUUID()) || next.getX() != $chunkX || next.getZ() != $chunkZ) continue;
            if (!next.removeMinion($minion)) break;
            iterator.remove();
            break;
        }
    }
}

